/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.util.LinkedTransferQueue;

public class DefaultSelectorHandler
implements SelectorHandler {
    protected long selectTimeout;

    @Override
    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    @Override
    public void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }

    @Override
    public void preSelect(SelectorRunner selectorRunner) throws IOException {
        this.processPendingOperations(selectorRunner);
    }

    @Override
    public Set<SelectionKey> select(SelectorRunner selectorRunner) throws IOException {
        Selector selector = selectorRunner.getSelector();
        selector.select(this.selectTimeout);
        return selector.selectedKeys();
    }

    @Override
    public void postSelect(SelectorRunner selectorRunner) throws IOException {
    }

    @Override
    public void registerKey(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.registerKey0(key, interest);
        } else {
            SelectionKeyOperation operation = new SelectionKeyOperation();
            operation.setOpType(OpType.REG_KEY);
            operation.setSelectionKey(key);
            operation.setInterest(interest);
            this.addPendingOperation(selectorRunner, operation);
        }
    }

    @Override
    public void unregisterKey(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.unregisterKey0(key, interest);
        } else {
            SelectionKeyOperation operation = new SelectionKeyOperation();
            operation.setOpType(OpType.UNREG_KEY);
            operation.setSelectionKey(key);
            operation.setInterest(interest);
            this.addPendingOperation(selectorRunner, operation);
        }
    }

    @Override
    public void registerChannel(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment) throws IOException {
        Future<RegisterChannelResult> future = this.registerChannelAsync(selectorRunner, channel, interest, attachment, null);
        try {
            future.get(this.selectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Future<RegisterChannelResult> registerChannelAsync(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) throws IOException {
        FutureImpl<RegisterChannelResult> future = new FutureImpl<RegisterChannelResult>();
        if (Thread.currentThread() == selectorRunner.getRunnerThread()) {
            this.registerChannel0(selectorRunner, channel, interest, attachment, completionHandler, future);
        } else {
            SelectionKeyOperation operation = new SelectionKeyOperation();
            operation.setOpType(OpType.REG_CHANNEL);
            operation.setChannel(channel);
            operation.setInterest(interest);
            operation.setAttachment(attachment);
            operation.setFuture(future);
            operation.setCompletionHandler(completionHandler);
            this.addPendingOperation(selectorRunner, operation);
        }
        return future;
    }

    protected void addPendingOperation(SelectorRunner selectorRunner, SelectionKeyOperation operation) {
        LinkedTransferQueue pendingSelectorOps = selectorRunner.getPendingOperations();
        pendingSelectorOps.offer(operation);
        selectorRunner.wakeupSelector();
    }

    protected void processPendingOperations(SelectorRunner selectorRunner) throws IOException {
        SelectionKeyOperation pendingOperation;
        LinkedTransferQueue pendingSelectorOps = selectorRunner.getPendingOperations();
        while ((pendingOperation = (SelectionKeyOperation)pendingSelectorOps.poll()) != null) {
            this.processPendingOperation(selectorRunner, pendingOperation);
        }
    }

    protected void processPendingOperation(SelectorRunner selectorRunner, SelectionKeyOperation operation) throws IOException {
        OpType opType = operation.getOpType();
        int interest = operation.getInterest();
        switch (opType) {
            case REG_CHANNEL: {
                this.registerChannel0(selectorRunner, operation.getChannel(), interest, operation.getAttachment(), operation.getCompletionHandler(), operation.getFuture());
                break;
            }
            case REG_KEY: {
                this.registerKey0(operation.getSelectionKey(), interest);
                break;
            }
            case UNREG_KEY: {
                this.unregisterKey0(operation.getSelectionKey(), interest);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation type: " + (Object)((Object)opType));
            }
        }
    }

    private void registerKey0(SelectionKey selectionKey, int interest) {
        int currentOps;
        if (selectionKey.isValid() && ((currentOps = selectionKey.interestOps()) & interest) != interest) {
            selectionKey.interestOps(currentOps | interest);
        }
    }

    private void unregisterKey0(SelectionKey selectionKey, int interest) {
        int currentOps;
        if (selectionKey.isValid() && ((currentOps = selectionKey.interestOps()) & interest) != 0) {
            selectionKey.interestOps(currentOps & ~interest);
        }
    }

    private void registerChannel0(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler completionHandler, FutureImpl<RegisterChannelResult> future) throws IOException {
        if (future == null || !future.isCancelled()) {
            try {
                if (channel.isOpen()) {
                    SelectionKey registeredSelectionKey = channel.register(selectorRunner.getSelector(), interest, attachment);
                    selectorRunner.getTransport().getSelectionKeyHandler().onKeyRegistered(registeredSelectionKey);
                    RegisterChannelResult result = new RegisterChannelResult(selectorRunner, registeredSelectionKey, channel);
                    if (completionHandler != null) {
                        completionHandler.completed(null, result);
                    }
                    if (future != null) {
                        future.setResult(result);
                    }
                } else {
                    ClosedChannelException error = new ClosedChannelException();
                    if (completionHandler != null) {
                        completionHandler.failed(null, error);
                    }
                    if (future != null) {
                        future.failure(error);
                    }
                }
            }
            catch (IOException e) {
                if (completionHandler != null) {
                    completionHandler.failed(null, e);
                }
                if (future != null) {
                    future.failure(e);
                }
                throw e;
            }
        }
    }

    protected static class SelectionKeyOperation {
        private OpType opType;
        private SelectionKey selectionKey;
        private SelectableChannel channel;
        private int interest;
        private Object attachment;
        private FutureImpl<RegisterChannelResult> future;
        private CompletionHandler completionHandler;

        protected SelectionKeyOperation() {
        }

        public OpType getOpType() {
            return this.opType;
        }

        public void setOpType(OpType opType) {
            this.opType = opType;
        }

        public SelectionKey getSelectionKey() {
            return this.selectionKey;
        }

        public void setSelectionKey(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
        }

        public SelectableChannel getChannel() {
            return this.channel;
        }

        public void setChannel(SelectableChannel channel) {
            this.channel = channel;
        }

        public int getInterest() {
            return this.interest;
        }

        public void setInterest(int interest) {
            this.interest = interest;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public void setAttachment(Object attachment) {
            this.attachment = attachment;
        }

        public FutureImpl<RegisterChannelResult> getFuture() {
            return this.future;
        }

        public void setFuture(FutureImpl<RegisterChannelResult> future) {
            this.future = future;
        }

        public CompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }

        public void setCompletionHandler(CompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
        }
    }

    protected static enum OpType {
        NONE,
        REG_CHANNEL,
        REG_KEY,
        UNREG_KEY;

    }
}

