/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.nio.AbstractNIOConnectionDistributor;
import org.glassfish.grizzly.nio.AbstractNIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;

public class RoundRobinConnectionDistributor
extends AbstractNIOConnectionDistributor {
    private AtomicInteger counter = new AtomicInteger();

    public RoundRobinConnectionDistributor(AbstractNIOTransport transport) {
        super(transport);
    }

    @Override
    public void registerChannel(SelectableChannel channel, int interestOps, Object attachment) throws IOException {
        SelectorRunner runner = this.getSelectorRunner(interestOps);
        this.transport.getSelectorHandler().registerChannel(runner, channel, interestOps, attachment);
    }

    @Override
    public Future<RegisterChannelResult> registerChannelAsync(SelectableChannel channel, int interestOps, Object attachment, CompletionHandler completionHandler) throws IOException {
        SelectorRunner runner = this.getSelectorRunner(interestOps);
        return this.transport.getSelectorHandler().registerChannelAsync(runner, channel, interestOps, attachment, completionHandler);
    }

    private SelectorRunner getSelectorRunner(int interestOps) {
        SelectorRunner[] runners = this.getTransportSelectorRunners();
        int index = interestOps == 16 || runners.length == 1 ? 0 : this.counter.incrementAndGet() % (runners.length - 1) + 1;
        return runners[index];
    }
}

