/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.nio.AbstractNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class TCPNIOAsyncQueueWriter
extends AbstractNIOAsyncQueueWriter {
    public TCPNIOAsyncQueueWriter(NIOTransport transport) {
        super(transport);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        if (dstAddress != null) {
            throw new UnsupportedOperationException("Destination address should be null for TCP!");
        }
        return super.write(connection, null, buffer, completionHandler, interceptor, cloner);
    }

    @Override
    protected int write0(Connection connection, SocketAddress dstAddress, Buffer buffer, WriteResult<Buffer, SocketAddress> currentResult) throws IOException {
        return ((TCPNIOTransport)this.transport).write(connection, buffer, currentResult);
    }

    @Override
    protected void onReadyToWrite(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        this.transport.getSelectorHandler().registerKey(nioConnection.getSelectorRunner(), nioConnection.getSelectionKey(), 4);
    }

    public Context context() {
        return null;
    }

    public void beforeProcess(Context context) throws IOException {
    }

    public void afterProcess(Context context) throws IOException {
    }
}

