/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.streams.AbstractStreamReader;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.util.conditions.Condition;

public class TCPNIOStreamReader
extends AbstractStreamReader {
    public TCPNIOStreamReader(TCPNIOConnection connection) {
        super(connection);
    }

    @Override
    public Future<Integer> notifyCondition(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        if (this.notifyObject != null) {
            throw new IllegalStateException("Only one available listener allowed!");
        }
        if (this.isClosed()) {
            EOFException exception = new EOFException();
            if (completionHandler != null) {
                completionHandler.failed(this.getConnection(), exception);
            }
            return new ReadyFutureImpl<Integer>(exception);
        }
        int availableDataSize = this.availableDataSize();
        if (condition.check(this)) {
            if (completionHandler != null) {
                completionHandler.completed(this.getConnection(), availableDataSize);
            }
            return new ReadyFutureImpl<Integer>(availableDataSize);
        }
        if (this.isBlocking()) {
            return this.notifyConditionBlocking(condition, completionHandler);
        }
        return this.notifyConditionNonBlocking(condition, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Integer> notifyConditionNonBlocking(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        final FutureImpl<Integer> future = new FutureImpl<Integer>(this.sync);
        Object object = this.sync;
        synchronized (object) {
            try {
                this.notifyObject = new AbstractStreamReader.NotifyObject(future, completionHandler, condition);
                Connection connection = this.getConnection();
                TCPNIOTransport transport = (TCPNIOTransport)connection.getTransport();
                transport.getAsyncQueueIO().getReader().read(connection, null, null, new Interceptor(){

                    public int intercept(int event, Object context, Object result) {
                        if (event == 1) {
                            ReadResult readResult = (ReadResult)result;
                            Buffer buffer = (Buffer)readResult.getMessage();
                            readResult.setMessage(null);
                            if (buffer == null) {
                                return 2;
                            }
                            buffer.flip();
                            TCPNIOStreamReader.this.append(buffer);
                            if (future.isDone()) {
                                return 1;
                            }
                            return 6;
                        }
                        return 0;
                    }
                });
            }
            catch (IOException e) {
                future.failure(e);
            }
        }
        return future;
    }

    private Future<Integer> notifyConditionBlocking(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        FutureImpl<Integer> future = new FutureImpl<Integer>();
        this.notifyObject = new AbstractStreamReader.NotifyObject(future, completionHandler, condition);
        try {
            while (!future.isDone()) {
                Buffer buffer = this.read0();
                this.append(buffer);
            }
        }
        catch (Exception e) {
            future.failure(e);
        }
        return future;
    }

    @Override
    protected Buffer read0() throws IOException {
        Connection connection = this.getConnection();
        if (this.isBlocking()) {
            TCPNIOTransport transport = (TCPNIOTransport)connection.getTransport();
            Buffer buffer = this.newBuffer(this.bufferSize);
            try {
                TemporarySelectorReader reader = (TemporarySelectorReader)transport.getTemporarySelectorIO().getReader();
                Future<ReadResult<Buffer, SocketAddress>> future = reader.read(connection, buffer, null, null, this.timeoutMillis, TimeUnit.MILLISECONDS);
                future.get();
                buffer.trim();
            }
            catch (Exception e) {
                buffer.dispose();
                throw new EOFException();
            }
            return buffer;
        }
        TCPNIOTransport transport = (TCPNIOTransport)connection.getTransport();
        Buffer buffer = this.newBuffer(this.bufferSize);
        try {
            int readBytes = transport.read(connection, buffer);
            if (readBytes <= 0) {
                if (readBytes == -1) {
                    throw new EOFException();
                }
                buffer.dispose();
                buffer = null;
            } else {
                buffer.trim();
            }
        }
        catch (IOException e) {
            buffer.dispose();
            buffer = null;
            throw e;
        }
        return buffer;
    }

    @Override
    protected final Object wrap(Buffer buffer) {
        return buffer;
    }

    @Override
    protected final Buffer unwrap(Object data) {
        return (Buffer)data;
    }
}

