/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOStreamReader;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class TCPNIOTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final TCPNIOTransport transport;

    TCPNIOTransportFilter(TCPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TCPNIOConnection connection = (TCPNIOConnection)ctx.getConnection();
        TCPNIOStreamReader reader = (TCPNIOStreamReader)connection.getStreamReader();
        Buffer buffer = reader.read0();
        reader.appendBuffer(buffer);
        if (reader.availableDataSize() <= 0) {
            return ctx.getStopAction();
        }
        ctx.setStreamReader(connection.getStreamReader());
        ctx.setStreamWriter(connection.getStreamWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        if (message != null) {
            Connection connection = ctx.getConnection();
            connection.getStreamWriter().writeBuffer((Buffer)message);
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

