/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOStreamReader;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.streams.AddressableStreamWriter;

public class UDPNIOStreamTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final UDPNIOTransport transport;

    UDPNIOStreamTransportFilter(UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
        UDPNIOStreamReader reader = (UDPNIOStreamReader)connection.getStreamReader();
        ReadResult result = reader.read0();
        reader.append(result);
        if (reader.availableDataSize() <= 0) {
            return ctx.getStopAction();
        }
        ctx.setStreamReader(connection.getStreamReader());
        ctx.setStreamWriter(connection.getStreamWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        Object dstAddress = ctx.getAddress();
        if (message != null) {
            UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
            AddressableStreamWriter writer = (AddressableStreamWriter)connection.getStreamWriter();
            if (!connection.isConnected()) {
                writer.setPeerAddress((SocketAddress)dstAddress);
            }
            writer.writeBuffer((Buffer)message);
            writer.flush();
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

