/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.rcm;

import java.io.IOException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.threadpool.DefaultThreadPool;

public class ResourceAllocationFilter
extends FilterAdapter {
    protected static final String RESERVE = "reserve";
    protected static final String CEILING = "ceiling";
    protected static final String ALLOCATION_MODE = "org.glassfish.grizzly.rcm.policyMethod";
    protected static final String RULE_TOKENS = "org.glassfish.grizzly.rcm.policyMetric";
    private static final String DELAY_VALUE = "org.glassfish.grizzly.rcm.delay";
    protected static final String QUERY_STRING = "?";
    protected static final String PATH_STRING = "/";
    protected static final ConcurrentHashMap<String, ExecutorService> threadPools = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<String, Double> privilegedTokens = new ConcurrentHashMap();
    protected static double leftRatio = 1.0;
    protected static String allocationPolicy = "reserve";
    private static long delayValue = 5000L;

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        ExecutorService threadPool;
        StringBuilder sb;
        StreamReader reader = ctx.getStreamReader();
        if (!this.parse(reader, 0, sb = new StringBuilder(256))) {
            return ctx.getStopAction();
        }
        String token = this.getContextRoot(sb.toString());
        int delayCount = 0;
        while (leftRatio == 0.0 && privilegedTokens.get(token) == null) {
            if (allocationPolicy.equals(RESERVE)) {
                this.delay(ctx);
                ++delayCount;
            } else if (allocationPolicy.equals(CEILING)) {
                if (!this.isThreadPoolInUse()) break;
                this.delay(ctx);
                ++delayCount;
            }
            if (delayCount <= 5) continue;
            ctx.getConnection().close();
            return ctx.getStopAction();
        }
        if ((threadPool = threadPools.get(token)) == null) {
            threadPool = this.filterRequest(token, ctx.getConnection().getTransport().getWorkerThreadPool());
            threadPools.put(token, threadPool);
        }
        ctx.setCurrentFilterIdx(ctx.getCurrentFilterIdx() + 1);
        threadPool.execute(ctx.getProcessorRunnable());
        return ctx.getSuspendAction();
    }

    private void delay(Context ctx) {
        try {
            Thread.sleep(delayValue);
        }
        catch (InterruptedException ex) {
            Grizzly.logger.log(Level.SEVERE, "Delay exception", ex);
        }
    }

    public ExecutorService filterRequest(String token, ExecutorService p) {
        ExecutorService es = null;
        if (p instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)p;
            int maxThreads = threadPool.getMaximumPoolSize();
            threadPool.setCorePoolSize(1);
            Double threadRatio = privilegedTokens.get(token);
            boolean defaultThreadPool = false;
            if (threadRatio == null) {
                es = threadPools.get("*");
                if (es != null) {
                    return es;
                }
                threadRatio = leftRatio == 0.0 ? 0.5 : leftRatio;
                defaultThreadPool = true;
            }
            int privilegedCount = threadRatio == 1.0 ? maxThreads : (int)((double)maxThreads * threadRatio) + 1;
            es = this.newThreadPool(privilegedCount, p);
            if (defaultThreadPool) {
                threadPools.put("*", es);
            }
        }
        return es;
    }

    protected ExecutorService newThreadPool(int threadCount, ExecutorService p) {
        if (threadCount == 0) {
            return null;
        }
        DefaultThreadPool threadPool = new DefaultThreadPool();
        threadPool.setCorePoolSize(1);
        threadPool.setMaximumPoolSize(threadCount);
        threadPool.setName("RCM_" + threadCount);
        threadPool.start();
        return threadPool;
    }

    protected boolean isThreadPoolInUse() {
        Collection<ExecutorService> collection = threadPools.values();
        for (ExecutorService threadPool : collection) {
            ThreadPoolExecutor pool;
            if (!(threadPool instanceof ThreadPoolExecutor) || (pool = (ThreadPoolExecutor)threadPool).getQueue().size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected String getContextRoot(String token) {
        boolean slash;
        int index = token.indexOf(QUERY_STRING);
        if (index != -1) {
            token = token.substring(0, index);
        }
        if (slash = token.endsWith(PATH_STRING)) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }

    protected boolean parse(StreamReader reader, int state, StringBuilder sb) throws IOException {
        Buffer currentBuffer;
        if (this.findSpace(reader, state, sb) == 2) {
            return true;
        }
        int size = reader.availableDataSize();
        if (size > (currentBuffer = reader.getBuffer()).remaining()) {
            reader.finishBuffer();
            boolean ret = this.parse(reader, state, sb);
            reader.prependBuffer(currentBuffer);
            return ret;
        }
        return false;
    }

    private int findSpace(StreamReader reader, int state, StringBuilder sb) {
        Buffer currentBuffer = reader.getBuffer();
        int pos = currentBuffer.position();
        int lim = currentBuffer.limit();
        for (int i = pos; i < lim; ++i) {
            char c = (char)currentBuffer.get(i);
            if (c == ' ') {
                if (++state != 2) continue;
                return state;
            }
            if (state != 1) continue;
            sb.append(c);
        }
        return state;
    }

    static {
        try {
            if (System.getProperty(RULE_TOKENS) != null) {
                StringTokenizer privList = new StringTokenizer(System.getProperty(RULE_TOKENS), ",");
                double countRatio = 0.0;
                while (privList.hasMoreElements()) {
                    StringTokenizer privElement = new StringTokenizer(privList.nextToken());
                    while (privElement.hasMoreElements()) {
                        String tokens = privElement.nextToken();
                        int index = tokens.indexOf("|");
                        double tokenValue = Double.valueOf(tokens.substring(index + 1));
                        privilegedTokens.put(tokens.substring(0, index), tokenValue);
                        countRatio += tokenValue;
                    }
                }
                if (countRatio > 1.0) {
                    Grizzly.logger.info("Thread ratio too high. The total must be lower or equal to 1");
                } else {
                    leftRatio = 1.0 - countRatio;
                }
            }
        }
        catch (Exception ex) {
            Grizzly.logger.log(Level.SEVERE, "Unable to set the ratio", ex);
        }
        if (System.getProperty(ALLOCATION_MODE) != null && !(allocationPolicy = System.getProperty(ALLOCATION_MODE)).equals(RESERVE) && !allocationPolicy.equals(CEILING)) {
            Grizzly.logger.info("Invalid allocation policy");
            allocationPolicy = RESERVE;
        }
    }
}

