/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.smart.SequenceUnit;
import org.glassfish.grizzly.smart.SmartTransformer;
import org.glassfish.grizzly.smart.annotations.Codec;
import org.glassfish.grizzly.smart.transformers.ArrayDecoder;
import org.glassfish.grizzly.smart.transformers.ByteDecoder;
import org.glassfish.grizzly.smart.transformers.CharDecoder;
import org.glassfish.grizzly.smart.transformers.DoubleDecoder;
import org.glassfish.grizzly.smart.transformers.FloatDecoder;
import org.glassfish.grizzly.smart.transformers.IntegerDecoder;
import org.glassfish.grizzly.smart.transformers.LongDecoder;
import org.glassfish.grizzly.smart.transformers.ShortDecoder;
import org.glassfish.grizzly.smart.transformers.SmartMemberTransformer;
import org.glassfish.grizzly.smart.transformers.SmartStringDecoder;

public class SmartDecoderTransformer<E>
extends AbstractTransformer<Buffer, E>
implements SmartTransformer<Buffer, E> {
    public static final String MESSAGE_PROCESSING_TREE_ATTR_NAME = "SmartDecoderTransformer.processingTree";
    private Map<Class, Class<? extends Transformer>> predefinedTransformers;
    private Class<E> messageClass;
    private List<SequenceUnit> decodingSequence;
    protected Attribute<List> messageProcessingTreeAttribute;
    protected Attribute<Integer> currentTransformerIdxAttribute;

    public SmartDecoderTransformer(Class<E> messageClass) {
        this.messageClass = messageClass;
        this.initializePredefinedTransformers();
        this.decodingSequence = new ArrayList<SequenceUnit>();
        this.createTransformerSequence(messageClass, this.decodingSequence);
        this.currentTransformerIdxAttribute = this.attributeBuilder.createAttribute("SmartDecoderTransformer.currentTransformerIdx");
        this.messageProcessingTreeAttribute = this.attributeBuilder.createAttribute(MESSAGE_PROCESSING_TREE_ATTR_NAME);
    }

    public Class<E> getMessageClass() {
        return this.messageClass;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TransformationResult<E> transform(AttributeStorage storage, Buffer input, E output) throws TransformationException {
        currentElementIndex = 0;
        processingTree = SmartDecoderTransformer.getValue(storage, this.messageProcessingTreeAttribute);
        if (processingTree == null) {
            rootMessage = output == null ? SmartDecoderTransformer.newInstance(this.messageClass) : output;
            processingTree = new ArrayList<Object>();
            processingTree.add(rootMessage);
            this.messageProcessingTreeAttribute.set(storage.obtainAttributes(), processingTree);
            currentElementIndex = 0;
        } else {
            currentElementIndex = SmartDecoderTransformer.getValue(storage, this.currentTransformerIdxAttribute);
        }
        while (currentElementIndex < this.decodingSequence.size()) {
            sequenceUnit = this.decodingSequence.get(currentElementIndex);
            switch (1.$SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type[sequenceUnit.getType().ordinal()]) {
                case 1: {
                    transformerUnit = (SequenceUnit.TransformUnit)sequenceUnit;
                    transformer = transformerUnit.transformer;
                    result = transformer.transform(storage, input, null);
                    status = result.getStatus();
                    if (status != TransformationResult.Status.COMPLETED) ** GOTO lbl33
                    object = processingTree.get(processingTree.size() - 1);
                    try {
                        transformedObject = result.getMessage();
                        transformerUnit.field.set(object, transformedObject);
                    }
                    catch (Exception e) {
                        throw new TransformationException(e);
                    }
                    finally {
                        transformer.release(storage);
                    }
                    ++currentElementIndex;
                    break;
lbl33:
                    // 1 sources

                    if (status == TransformationResult.Status.INCOMPLED) {
                        this.saveStatus(storage, processingTree, currentElementIndex, SmartDecoderTransformer.incompletedResult);
                        return SmartDecoderTransformer.incompletedResult;
                    }
                    transformer.release(storage);
                    return result;
                }
                case 2: {
                    instantiateUnit = (SequenceUnit.InstantiateUnit)sequenceUnit;
                    field = instantiateUnit.field;
                    instValue = SmartDecoderTransformer.newInstance(field.getType());
                    parentObject = processingTree.get(processingTree.size() - 1);
                    try {
                        field.set(parentObject, instValue);
                    }
                    catch (Exception e) {
                        throw new TransformationException(e);
                    }
                    ++currentElementIndex;
                    break;
                }
                case 3: {
                    stepInUnit = (SequenceUnit.StepInUnit)sequenceUnit;
                    parentObject = processingTree.get(processingTree.size() - 1);
                    try {
                        stepInObject = stepInUnit.field.get(parentObject);
                    }
                    catch (Exception e) {
                        throw new TransformationException(e);
                    }
                    processingTree.add(stepInObject);
                    ++currentElementIndex;
                    break;
                }
                case 4: {
                    processingTree.remove(processingTree.size() - 1);
                    ++currentElementIndex;
                }
            }
        }
        result = new TransformationResult<E>(TransformationResult.Status.COMPLETED, processingTree.get(0));
        this.saveStatus(storage, processingTree, currentElementIndex, result);
        return result;
    }

    @Override
    public void release(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            this.messageProcessingTreeAttribute.remove(holder);
            this.currentTransformerIdxAttribute.remove(holder);
        }
        super.release(storage);
    }

    public Map<Class, Class<? extends Transformer>> getPredefinedTransformers() {
        return this.predefinedTransformers;
    }

    @Override
    public Transformer createTransformer(Class fieldType, Class<? extends Transformer> prefTransformerClass) {
        if (prefTransformerClass != null) {
            return SmartDecoderTransformer.newInstance(prefTransformerClass);
        }
        Class<Transformer> transformerClass = this.getTransformer(fieldType);
        if (transformerClass != null) {
            return SmartDecoderTransformer.newInstance(transformerClass);
        }
        return null;
    }

    private void createTransformerSequence(Class messageClass, List<SequenceUnit> sequence) {
        for (Field field : messageClass.getDeclaredFields()) {
            String prefTransformerTypeName;
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers)) continue;
            Class<?> prefTransformerType = null;
            Codec codec = field.getAnnotation(Codec.class);
            if (codec != null && codec.decoder() != null && (prefTransformerTypeName = codec.decoder()) != null && prefTransformerTypeName.length() > 0) {
                try {
                    prefTransformerType = Class.forName(prefTransformerTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            Class<?> type = field.getType();
            Transformer transformer = this.createTransformer(type, prefTransformerType);
            field.setAccessible(true);
            if (transformer != null) {
                this.initializeTransformer(transformer, field);
                sequence.add(new SequenceUnit.TransformUnit(transformer, field));
                continue;
            }
            sequence.add(new SequenceUnit.InstantiateUnit(field));
            sequence.add(new SequenceUnit.StepInUnit(field));
            this.createTransformerSequence(type, sequence);
            sequence.add(new SequenceUnit.StepOutUnit());
        }
    }

    private void initializePredefinedTransformers() {
        this.predefinedTransformers = new HashMap<Class, Class<? extends Transformer>>();
        this.predefinedTransformers.put(Byte.class, ByteDecoder.class);
        this.predefinedTransformers.put(Byte.TYPE, ByteDecoder.class);
        this.predefinedTransformers.put(Short.class, ShortDecoder.class);
        this.predefinedTransformers.put(Short.TYPE, ShortDecoder.class);
        this.predefinedTransformers.put(Character.class, CharDecoder.class);
        this.predefinedTransformers.put(Character.TYPE, CharDecoder.class);
        this.predefinedTransformers.put(Integer.class, IntegerDecoder.class);
        this.predefinedTransformers.put(Integer.TYPE, IntegerDecoder.class);
        this.predefinedTransformers.put(Long.class, LongDecoder.class);
        this.predefinedTransformers.put(Long.TYPE, LongDecoder.class);
        this.predefinedTransformers.put(Float.class, FloatDecoder.class);
        this.predefinedTransformers.put(Float.TYPE, FloatDecoder.class);
        this.predefinedTransformers.put(Double.class, DoubleDecoder.class);
        this.predefinedTransformers.put(Double.TYPE, DoubleDecoder.class);
        this.predefinedTransformers.put(String.class, SmartStringDecoder.class);
        this.predefinedTransformers.put(Array.class, ArrayDecoder.class);
    }

    private void saveStatus(AttributeStorage storage, List messageProcessingTree, int index, TransformationResult<E> lastResult) {
        SmartDecoderTransformer.setValue(storage, this.currentTransformerIdxAttribute, index);
        SmartDecoderTransformer.setValue(storage, this.messageProcessingTreeAttribute, messageProcessingTree);
        SmartDecoderTransformer.setValue(storage, this.lastResultAttribute, lastResult);
    }

    protected Class<? extends Transformer> getTransformer(Class clazz) {
        if (clazz.isArray()) {
            return this.predefinedTransformers.get(Array.class);
        }
        return this.predefinedTransformers.get(clazz);
    }

    private void initializeTransformer(Transformer transformer, Field field) {
        if (transformer instanceof SmartMemberTransformer) {
            ((SmartMemberTransformer)transformer).initialize(this, field);
        }
    }

    private static <E> E newInstance(Class<E> clazz) {
        try {
            E instance = clazz.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not initialize class: " + clazz.getName(), e);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type;

        static {
            $SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type = new int[SequenceUnit.Type.values().length];
            try {
                1.$SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type[SequenceUnit.Type.TRANSFORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type[SequenceUnit.Type.INSTANTIATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type[SequenceUnit.Type.STEPIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$glassfish$grizzly$smart$SequenceUnit$Type[SequenceUnit.Type.STEPOUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

