/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.filterchain.CodecFilter;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.smart.SmartCodec;

public class SmartFilter<K>
extends FilterAdapter
implements CodecFilter<Buffer, K> {
    private AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    private Attribute<Buffer> remainderAttribute;
    private SmartCodec<K> smartCodec;

    public SmartFilter(Class clazz) {
        this(new SmartCodec(clazz));
    }

    public SmartFilter(SmartCodec<K> smartCodec) {
        this.smartCodec = smartCodec;
        this.remainderAttribute = this.attributeBuilder.createAttribute("UTFStringFilter.remainder");
    }

    public SmartFilter(SmartCodec<K> smartCodec, AttributeBuilder attrBuilder) {
        this.smartCodec = smartCodec;
        this.attributeBuilder = attrBuilder;
        this.remainderAttribute = this.attributeBuilder.createAttribute("SmartFilter.remainder");
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Buffer message = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        Transformer<Buffer, Buffer> decoder = this.getDecoder();
        TransformationResult<Object> result = decoder.transform(connection, message, null);
        switch (result.getStatus()) {
            case COMPLETED: {
                decoder.release(connection);
                ctx.setMessage(result.getMessage());
                if (message.hasRemaining()) {
                    this.remainderAttribute.set(ctx.obtainAttributes(), message);
                }
                return nextAction;
            }
            case INCOMPLED: {
                return ctx.getStopAction();
            }
        }
        decoder.release(connection);
        throw new IllegalStateException(result.getErrorCode() + ": " + result.getErrorDescription());
    }

    @Override
    public NextAction postRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Buffer remainder;
        AttributeHolder holder = ctx.getAttributes();
        if (holder != null && (remainder = this.remainderAttribute.remove(holder)) != null) {
            ctx.setMessage(remainder);
            nextAction = ctx.getRerunChainAction();
        }
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Connection connection = ctx.getConnection();
        Transformer<Object, Buffer> encoder = this.getEncoder();
        TransformationResult<Object> result = encoder.transform(connection, ctx.getMessage(), null);
        ctx.setMessage(result.getMessage());
        encoder.release(connection);
        return nextAction;
    }

    @Override
    public Transformer<Buffer, K> getDecoder() {
        return this.smartCodec.getDecoder();
    }

    @Override
    public Transformer<K, Buffer> getEncoder() {
        return this.smartCodec.getEncoder();
    }
}

