/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart.transformers;

import java.lang.reflect.Array;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.smart.transformers.SequenceDecoder;

public class ArrayDecoder
extends SequenceDecoder<Object> {
    protected Attribute<Integer> currentElementIdxAttribute;

    public ArrayDecoder() {
        String prefix = ArrayDecoder.class.getName();
        this.currentElementIdxAttribute = this.attributeBuilder.createAttribute(prefix + ".currentElementIdx");
    }

    @Override
    public TransformationResult<Object> transform(AttributeStorage storage, Buffer input, Object output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input should not be null");
        }
        Object sequence = this.getSequence(storage);
        if (sequence == null) {
            int size = this.checkSize(storage);
            sequence = this.createSequence(storage, size);
        }
        if (this.componentType.isPrimitive() && this.componentType.equals(Byte.TYPE)) {
            int currentElementIdx = ArrayDecoder.getValue(storage, this.currentElementIdxAttribute, 0);
            byte[] byteArray = (byte[])sequence;
            if (input.remaining() < byteArray.length) {
                this.saveState(storage, byteArray, currentElementIdx, incompletedResult);
                return incompletedResult;
            }
            input.get(byteArray);
            TransformationResult<Object> result = new TransformationResult<Object>(TransformationResult.Status.COMPLETED, sequence);
            this.saveState(storage, byteArray, byteArray.length, result);
            return result;
        }
        return super.transform(storage, input, output);
    }

    private void saveState(AttributeStorage storage, Object array, int currentElementIdx, TransformationResult<Object> lastResult) {
        ArrayDecoder.setValue(storage, this.currentElementIdxAttribute, currentElementIdx);
        super.saveState(storage, array, lastResult);
    }

    @Override
    public void release(AttributeStorage storage) {
        ArrayDecoder.removeValue(storage, this.currentElementIdxAttribute);
        super.release(storage);
    }

    @Override
    protected Object createSequence(AttributeStorage storage, int size) {
        return Array.newInstance(this.getComponentType(), size);
    }

    @Override
    protected void set(AttributeStorage storage, Object sequence, Object component) {
        int currentElementIdx = ArrayDecoder.getValue(storage, this.currentElementIdxAttribute, 0);
        Array.set(sequence, currentElementIdx, component);
    }

    @Override
    protected boolean next(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayDecoder.getValue(storage, this.currentElementIdxAttribute, -1);
        if (currentElementIdx < Array.getLength(sequence)) {
            ArrayDecoder.setValue(storage, this.currentElementIdxAttribute, ++currentElementIdx);
            return true;
        }
        return false;
    }

    @Override
    protected int size(AttributeStorage storage, Object sequence) {
        return Array.getLength(sequence);
    }
}

