/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart.transformers;

import java.lang.reflect.Array;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.smart.transformers.SequenceEncoder;

public class ArrayEncoder
extends SequenceEncoder<Object> {
    protected Attribute<Integer> currentElementIdxAttribute;

    public ArrayEncoder() {
        String prefix = ArrayEncoder.class.getName();
        this.currentElementIdxAttribute = this.attributeBuilder.createAttribute(prefix + ".currentElementIdx");
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage storage, Object input, Buffer output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input should not be null");
        }
        if (this.componentType.isPrimitive() && this.componentType.equals(Byte.TYPE)) {
            MemoryManager memoryManager = null;
            if (output == null) {
                if (storage instanceof Connection) {
                    Connection connection = (Connection)storage;
                    memoryManager = connection.getTransport().getMemoryManager();
                    output = memoryManager.allocate(this.size(storage, input));
                } else {
                    throw new TransformationException("Output Buffer is null and there is no way to allocate one");
                }
            }
            int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, 0);
            int size = this.size(storage, input);
            int bytesToCopy = Math.min(output.remaining(), size - currentElementIdx);
            output.put((byte[])input, currentElementIdx, bytesToCopy);
            if ((currentElementIdx += bytesToCopy) < size) {
                this.saveState(storage, currentElementIdx, incompletedResult);
                return incompletedResult;
            }
            TransformationResult<Buffer> result = new TransformationResult<Buffer>(TransformationResult.Status.COMPLETED, output.duplicate().flip());
            this.saveState(storage, result);
            return result;
        }
        return super.transform(storage, input, output);
    }

    @Override
    public void release(AttributeStorage storage) {
        ArrayEncoder.removeValue(storage, this.currentElementIdxAttribute);
        super.release(storage);
    }

    @Override
    protected Object get(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        return Array.get(sequence, currentElementIdx);
    }

    @Override
    protected boolean previous(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        if (currentElementIdx >= 0) {
            ArrayEncoder.setValue(storage, this.currentElementIdxAttribute, --currentElementIdx);
            return true;
        }
        return false;
    }

    @Override
    protected boolean next(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        if (currentElementIdx < Array.getLength(sequence)) {
            ArrayEncoder.setValue(storage, this.currentElementIdxAttribute, ++currentElementIdx);
            return true;
        }
        return false;
    }

    @Override
    protected int size(AttributeStorage storage, Object sequence) {
        return Array.getLength(sequence);
    }

    protected void saveState(AttributeStorage storage, int currentElementIdx, TransformationResult<Buffer> lastResult) {
        ArrayEncoder.setValue(storage, this.currentElementIdxAttribute, currentElementIdx);
        super.saveState(storage, lastResult);
    }
}

