/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Codec;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.ssl.BlockingSSLHandshaker;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLDecoderTransformer;
import org.glassfish.grizzly.ssl.SSLEncoderTransformer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLHandshaker;

public class SSLCodec
implements Codec<Buffer, Buffer> {
    private SSLHandshaker sslHandshaker;
    private final SSLContext sslContext;
    private final SSLEngineConfigurator serverSSLEngineConfig;
    private final SSLEngineConfigurator clientSSLEngineConfig;
    private final Transformer<Buffer, Buffer> decoder;
    private final Transformer<Buffer, Buffer> encoder;

    public SSLCodec(SSLContextConfigurator config) {
        this(config.createSSLContext());
    }

    public SSLCodec(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.decoder = new SSLDecoderTransformer();
        this.encoder = new SSLEncoderTransformer();
        this.serverSSLEngineConfig = new SSLEngineConfigurator(sslContext, false, false, false);
        this.clientSSLEngineConfig = new SSLEngineConfigurator(sslContext, true, false, false);
        this.sslHandshaker = new BlockingSSLHandshaker();
    }

    @Override
    public Transformer<Buffer, Buffer> getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer<Buffer, Buffer> getEncoder() {
        return this.encoder;
    }

    public SSLEngineConfigurator getClientSSLEngineConfig() {
        return this.clientSSLEngineConfig;
    }

    public SSLEngineConfigurator getServerSSLEngineConfig() {
        return this.serverSSLEngineConfig;
    }

    public SSLHandshaker getSslHandshaker() {
        return this.sslHandshaker;
    }

    public void setSslHandshaker(SSLHandshaker sslHandshaker) {
        this.sslHandshaker = sslHandshaker;
    }

    public Future<SSLEngine> handshake(Connection connection) throws IOException {
        return this.handshake(connection, this.clientSSLEngineConfig);
    }

    public Future<SSLEngine> handshake(Connection connection, SSLEngineConfigurator configurator) throws IOException {
        return null;
    }
}

