/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.threadpool.WorkerThread;

public class SSLEncoderTransformer
implements Transformer<Buffer, Buffer> {
    public static final int NEED_HANDSHAKE_ERROR = 1;
    public static final int BUFFER_UNDERFLOW_ERROR = 2;
    public static final int BUFFER_OVERFLOW_ERROR = 3;
    private static Attribute<TransformationResult<Buffer>> lastResultAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLEncoderTransformer.lastResult");
    private Logger logger = Grizzly.logger;

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage state) throws TransformationException {
        return this.transform(state, this.getInput(state), this.getOutput(state));
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage state, Buffer originalMessage, Buffer targetMessage) throws TransformationException {
        SSLResourcesAccessor resourceAccessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = resourceAccessor.getSSLEngine(state);
        if (sslEngine == null) {
            throw new IllegalStateException("There is no SSLEngine associated! May be handshake phase was not executed?");
        }
        if (originalMessage == null) {
            originalMessage = this.getInput(state);
        }
        if (targetMessage == null) {
            targetMessage = this.getOutput(state);
        }
        TransformationResult<Buffer> transformationResult = null;
        SSLEngineResult sslEngineResult = null;
        do {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("SSLEncoder engine: " + sslEngine + " input: " + originalMessage + " output: " + targetMessage);
                }
                sslEngineResult = sslEngine.wrap((ByteBuffer)originalMessage.underlying(), (ByteBuffer)targetMessage.underlying());
                SSLEngineResult.Status status = sslEngineResult.getStatus();
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("SSLEncoder done engine: " + sslEngine + " result: " + sslEngineResult + " input: " + originalMessage + " output: " + targetMessage);
            }
            catch (SSLException e) {
                throw new TransformationException(e);
            }
        } while (originalMessage.hasRemaining() && sslEngineResult.getStatus() == SSLEngineResult.Status.OK);
        SSLEngineResult.Status sslEngineStatus = sslEngineResult.getStatus();
        switch (sslEngineStatus) {
            case OK: {
                if (originalMessage.hasRemaining()) {
                    throw new IllegalStateException("Status is OK, but still have something to process? Buffer: " + originalMessage);
                }
            }
            case CLOSED: {
                transformationResult = new TransformationResult(TransformationResult.Status.COMPLETED, targetMessage.duplicate().flip());
                break;
            }
            case BUFFER_UNDERFLOW: {
                transformationResult = new TransformationResult(2, "Buffer underflow during wrap operation");
                break;
            }
            case BUFFER_OVERFLOW: {
                Buffer resultBuffer = targetMessage.duplicate().flip();
                if (resultBuffer.hasRemaining()) {
                    targetMessage.clear();
                    transformationResult = new TransformationResult(TransformationResult.Status.INCOMPLED, resultBuffer);
                    break;
                }
                transformationResult = new TransformationResult(3, "Buffer overflow during wrap operation");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected SSLEngine state: " + (Object)((Object)sslEngineStatus));
            }
        }
        lastResultAttr.set(state.obtainAttributes(), transformationResult);
        return transformationResult;
    }

    @Override
    public Buffer getInput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        return accessor.obtainAppBuffer(state);
    }

    @Override
    public void setInput(AttributeStorage state, Buffer input) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setAppBuffer(state, input);
    }

    @Override
    public Buffer getOutput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        return accessor.obtainSecuredOutBuffer(state);
    }

    @Override
    public void setOutput(AttributeStorage state, Buffer outputTarget) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setSecuredOutBuffer(state, outputTarget);
    }

    @Override
    public TransformationResult<Buffer> getLastResult(AttributeStorage state) {
        return lastResultAttr.get(state);
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage state) {
        return state.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage state) {
        Buffer outputBuffer;
        Buffer lastResultMessage;
        TransformationResult<Buffer> lastResult = this.getLastResult(state);
        if (lastResult != null && (lastResultMessage = lastResult.getMessage()) != null && lastResultMessage.hasRemaining() && this.detachOutputFromWorkerThread(outputBuffer = this.getOutput(state))) {
            this.setOutput(state, outputBuffer);
        }
    }

    @Override
    public void release(AttributeStorage state) {
        AttributeHolder holder = state.getAttributes();
        if (holder != null) {
            lastResultAttr.remove(holder);
        }
        Buffer output = this.getOutput(state);
        output.clear();
    }

    private boolean detachOutputFromWorkerThread(Buffer output) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread workerThread = (WorkerThread)((Object)thread);
            SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
            if (accessor.getSecuredOutBuffer(workerThread) == output) {
                accessor.setSecuredOutBuffer(workerThread, null);
                return true;
            }
        }
        return false;
    }
}

