/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.threadpool.WorkerThread;

public class SSLHandshakeEncoder
implements Transformer<Buffer, Buffer> {
    private Logger logger = Grizzly.logger;
    private TransformationResult<Buffer> lastResult;

    @Override
    public TransformationResult transform(AttributeStorage state) throws TransformationException {
        return this.transform(state, this.getInput(state), this.getOutput(state));
    }

    @Override
    public TransformationResult transform(AttributeStorage state, Buffer input, Buffer output) throws TransformationException {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = accessor.getSSLEngine(state);
        assert (sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP);
        if (input == null) {
            input = this.getInput(state);
        }
        if (output == null) {
            output = this.getOutput(state);
        }
        SSLEngineResult result = null;
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SSLHandshakeEncoder engine: " + sslEngine + " input: " + input + " output: " + output);
            }
            result = sslEngine.wrap((ByteBuffer)input.underlying(), (ByteBuffer)output.underlying());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SSLHandshakeEncoder engine: " + sslEngine + " result: " + result + " input: " + input + " output: " + output);
            }
        }
        catch (SSLException e) {
            throw new TransformationException(e);
        }
        if (!input.hasRemaining()) {
            accessor.setSecuredOutBuffer(state, null);
        }
        this.lastResult = new TransformationResult(TransformationResult.Status.COMPLETED, output.duplicate().flip());
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            // empty if block
        }
        return this.lastResult;
    }

    @Override
    public Buffer getInput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        Buffer buffer = accessor.obtainAppBuffer(state);
        buffer.position(buffer.limit());
        return buffer;
    }

    @Override
    public void setInput(AttributeStorage state, Buffer input) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setAppBuffer(state, input);
    }

    @Override
    public Buffer getOutput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        return accessor.obtainSecuredOutBuffer(state);
    }

    @Override
    public void setOutput(AttributeStorage state, Buffer output) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setSecuredOutBuffer(state, output);
    }

    @Override
    public TransformationResult<Buffer> getLastResult(AttributeStorage state) {
        return this.lastResult;
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage state) {
        return state.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage state) {
        Buffer lastResultMessage;
        if (this.lastResult != null && (lastResultMessage = this.lastResult.getMessage()) != null && lastResultMessage.hasRemaining()) {
            Buffer outputBuffer = this.getOutput(state);
            if (this.isWorkerThreadOutBuffer(outputBuffer)) {
                Connection connection = (Connection)state;
                Object newBuffer = connection.getTransport().getMemoryManager().allocate(lastResultMessage.remaining());
                newBuffer.put(lastResultMessage);
                newBuffer.flip();
                this.lastResult.setMessage((Buffer)newBuffer);
            }
            outputBuffer.clear();
        }
    }

    @Override
    public void release(AttributeStorage state) {
        Buffer output = this.getOutput(state);
        output.clear();
        this.lastResult = null;
    }

    private boolean isWorkerThreadOutBuffer(Buffer output) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread workerThread = (WorkerThread)((Object)thread);
            SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
            return accessor.getSecuredOutBuffer(workerThread) == output;
        }
        return false;
    }
}

