/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.streams.AbstractStreamReader;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public abstract class AbstractStreamWriter
implements StreamWriter {
    protected static final Integer ZERO = new Integer(0);
    protected static final Future<Integer> ZERO_READY_FUTURE = new ReadyFutureImpl<Integer>(ZERO);
    private Connection connection;
    private boolean isBlocking;
    protected int bufferSize = 8192;
    protected Buffer buffer;
    private long timeoutMillis = 30000L;
    private boolean isClosed = false;

    protected AbstractStreamWriter() {
        this(null);
    }

    protected AbstractStreamWriter(Connection connection) {
        this.setConnection(connection);
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    protected Future<Integer> overflow() throws IOException {
        return this.overflow(null);
    }

    protected Future<Integer> overflow(CompletionHandler<Integer> completionHandler) throws IOException {
        Future<Integer> future = null;
        if (this.buffer != null) {
            if (this.buffer.position() > 0) {
                future = this.flush0(this.buffer, completionHandler);
                if (!future.isDone()) {
                    this.buffer = this.newBuffer(this.bufferSize);
                }
                this.initBuffer();
            } else {
                future = ZERO_READY_FUTURE;
                if (completionHandler != null) {
                    completionHandler.completed(this.connection, ZERO);
                }
            }
        } else {
            this.buffer = this.newBuffer(this.bufferSize);
            this.initBuffer();
        }
        return future;
    }

    private void initBuffer() {
        this.buffer.clear();
    }

    @Override
    public Future<Integer> flush() throws IOException {
        return this.flush(null);
    }

    @Override
    public Future<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return this.overflow(completionHandler);
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> close(CompletionHandler<Integer> completionHandler) throws IOException {
        try {
            Future<Integer> future = this.close0(completionHandler);
            return future;
        }
        finally {
            this.buffer = null;
            this.isClosed = true;
        }
    }

    public void ensure(int size) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("ByteBufferWriter is closed");
        }
        if (this.buffer == null || this.buffer.remaining() < size) {
            this.overflow();
        }
        if (this.buffer.remaining() < size) {
            throw new RuntimeException("New allocated buffer is too small");
        }
    }

    @Override
    public void writeBuffer(Buffer b) throws IOException {
        this.writeBuffer(b, null);
    }

    protected void writeBuffer(Buffer b, CompletionHandler completionHandler) throws IOException {
        if (this.buffer != null && this.buffer.position() > 0) {
            this.overflow();
        }
        if (b != null && b.hasRemaining()) {
            b.position(b.limit());
            this.flush0(b, completionHandler);
        }
    }

    @Override
    public void writeStream(StreamReader streamReader) throws IOException {
        Buffer readerBuffer;
        AbstractStreamReader readerImpl = (AbstractStreamReader)streamReader;
        while ((readerBuffer = readerImpl.getBuffer()) != null) {
            readerImpl.finishBuffer();
            this.writeBuffer(readerBuffer, new DisposeBufferCompletionHandler(readerBuffer));
        }
    }

    @Override
    public void writeBoolean(boolean data) throws IOException {
        this.ensure(1);
        byte value = data ? (byte)1 : 0;
        this.buffer.put(value);
    }

    @Override
    public void writeByte(byte data) throws IOException {
        this.ensure(1);
        this.buffer.put(data);
    }

    @Override
    public void writeChar(char data) throws IOException {
        this.ensure(2);
        this.buffer.putChar(data);
    }

    @Override
    public void writeShort(short data) throws IOException {
        this.ensure(2);
        this.buffer.putShort(data);
    }

    @Override
    public void writeInt(int data) throws IOException {
        this.ensure(4);
        this.buffer.putInt(data);
    }

    @Override
    public void writeLong(long data) throws IOException {
        this.ensure(8);
        this.buffer.putLong(data);
    }

    @Override
    public void writeFloat(float data) throws IOException {
        this.ensure(4);
        this.buffer.putFloat(data);
    }

    @Override
    public void writeDouble(double data) throws IOException {
        this.ensure(8);
        this.buffer.putDouble(data);
    }

    @Override
    public void writeBooleanArray(boolean[] data) throws IOException {
        this.ensure(1);
        int ctr = 0;
        while (ctr < data.length) {
            int dataSizeToWrite = Math.min(data.length - ctr, this.buffer.remaining());
            for (int ctr2 = ctr; ctr2 < ctr + dataSizeToWrite; ++ctr2) {
                this.buffer.put((byte)(data[ctr2] ? 1 : 0));
            }
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeByteArray(byte[] data) throws IOException {
        this.writeByteArray(data, 0, data.length);
    }

    @Override
    public void writeByteArray(byte[] data, int offset, int length) throws IOException {
        this.ensure(1);
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(length - ctr, this.buffer.remaining());
            this.buffer.put(data, offset + ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == length) break;
            this.overflow();
        }
    }

    @Override
    public void writeCharArray(char[] data) throws IOException {
        this.ensure(2);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            CharBuffer typedBuffer = current.asCharBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.remaining());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            this.buffer.position(typedBuffer.position() * 2 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeShortArray(short[] data) throws IOException {
        this.ensure(2);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            ShortBuffer typedBuffer = current.asShortBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            current.position(typedBuffer.position() * 2 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeIntArray(int[] data) throws IOException {
        this.ensure(4);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            IntBuffer typedBuffer = current.asIntBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            current.position(typedBuffer.position() * 4 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeLongArray(long[] data) throws IOException {
        this.ensure(8);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            LongBuffer typedBuffer = current.asLongBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            current.position(typedBuffer.position() * 8 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeFloatArray(float[] data) throws IOException {
        this.ensure(4);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            FloatBuffer typedBuffer = current.asFloatBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            current.position(typedBuffer.position() * 4 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void writeDoubleArray(double[] data) throws IOException {
        this.ensure(8);
        int ctr = 0;
        while (true) {
            ByteBuffer current = (ByteBuffer)this.buffer.underlying();
            DoubleBuffer typedBuffer = current.asDoubleBuffer();
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            current.position(typedBuffer.position() * 8 + current.position());
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.bufferSize = connection.getWriteBufferSize();
            this.isBlocking = connection.isBlocking();
        }
        this.connection = connection;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    protected Buffer newBuffer(int size) {
        return this.getConnection().getTransport().getMemoryManager().allocate(size);
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    @Override
    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }

    protected abstract Future<Integer> flush0(Buffer var1, CompletionHandler<Integer> var2) throws IOException;

    protected abstract Future<Integer> close0(CompletionHandler<Integer> var1) throws IOException;

    public static class DisposeBufferCompletionHandler
    implements CompletionHandler {
        private Buffer buffer;

        public DisposeBufferCompletionHandler(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void cancelled(Connection connection) {
            this.disposeBuffer();
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            this.disposeBuffer();
        }

        public void completed(Connection connection, Object result) {
            this.disposeBuffer();
        }

        public void updated(Connection connection, Object result) {
        }

        protected void disposeBuffer() {
            this.buffer.dispose();
        }
    }
}

