/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.threadpool.ExtendedThreadPool;

public class DefaultScheduleThreadPool
extends ScheduledThreadPoolExecutor
implements ExtendedThreadPool,
Thread.UncaughtExceptionHandler {
    private static int DEFAULT_MIN_THREAD_COUNT = 1;
    protected AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    private String name = "Grizzly-Scheduled";
    private AtomicInteger workerThreadCounter = new AtomicInteger();

    public DefaultScheduleThreadPool() {
        this(DEFAULT_MIN_THREAD_COUNT);
    }

    public DefaultScheduleThreadPool(int corePoolSize) {
        super(corePoolSize);
        this.setThreadFactory(new DefaultWorkerThreadFactory(this));
    }

    public int getQueuedTasksCount() {
        return this.getQueue().size();
    }

    public int getMaxQueuedTasksCount() {
        return Integer.MAX_VALUE;
    }

    public void setMaxQueuedTasksCount(int maxTasksCount) {
        throw new UnsupportedOperationException("Value could not be changed!");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    public void start() {
        this.prestartCoreThread();
    }

    public void stop() {
        this.shutdownNow();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public void setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Grizzly.logger.log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        ((DefaultWorkerThread)t).onBeforeRun();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((DefaultWorkerThread)Thread.currentThread()).onAfterRun();
    }

    private static class DefaultWorkerThreadFactory
    implements ThreadFactory {
        private DefaultScheduleThreadPool threadPool;

        public DefaultWorkerThreadFactory(DefaultScheduleThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public Thread newThread(Runnable r) {
            DefaultWorkerThread thread = new DefaultWorkerThread(this.threadPool.getAttributeBuilder(), this.threadPool.getName() + "-ScheduledWorkerThread(" + this.threadPool.workerThreadCounter.getAndIncrement() + ")", r);
            thread.setUncaughtExceptionHandler(this.threadPool);
            return thread;
        }
    }
}

