/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.util.IOEventMask;

public class ArrayIOEventMask
implements IOEventMask {
    private boolean[] arrayMask = new boolean[IOEvent.values().length];

    public ArrayIOEventMask() {
        this(false);
    }

    public ArrayIOEventMask(boolean enableAllInterests) {
        if (enableAllInterests) {
            for (int i = 0; i < this.arrayMask.length; ++i) {
                this.arrayMask[i] = true;
            }
        }
    }

    public ArrayIOEventMask(IOEvent ... ioEvents) {
        for (IOEvent ioEvent : ioEvents) {
            this.setInterested(ioEvent, true);
        }
    }

    public ArrayIOEventMask(IOEventMask mask) {
        IOEvent[] ioEvents;
        for (IOEvent ioEvent : ioEvents = IOEvent.values()) {
            this.setInterested(ioEvent, mask.isInterested(ioEvent));
        }
    }

    @Override
    public boolean isInterested(IOEvent ioEvent) {
        int position = ioEvent.ordinal();
        return this.arrayMask[position];
    }

    @Override
    public void setInterested(IOEvent ioEvent, boolean isInterested) {
        int position = ioEvent.ordinal();
        this.arrayMask[position] = isInterested;
    }

    @Override
    public IOEventMask or(IOEventMask mask) {
        IOEvent[] ioEvents;
        ArrayIOEventMask newIOEventMask = new ArrayIOEventMask();
        for (IOEvent ioEvent : ioEvents = IOEvent.values()) {
            newIOEventMask.setInterested(ioEvent, this.isInterested(ioEvent) | mask.isInterested(ioEvent));
        }
        return newIOEventMask;
    }

    @Override
    public IOEventMask and(IOEventMask mask) {
        IOEvent[] ioEvents;
        ArrayIOEventMask newIOEventMask = new ArrayIOEventMask();
        for (IOEvent ioEvent : ioEvents = IOEvent.values()) {
            newIOEventMask.setInterested(ioEvent, this.isInterested(ioEvent) & mask.isInterested(ioEvent));
        }
        return newIOEventMask;
    }

    @Override
    public IOEventMask xor(IOEventMask mask) {
        IOEvent[] ioEvents;
        ArrayIOEventMask newIOEventMask = new ArrayIOEventMask();
        for (IOEvent ioEvent : ioEvents = IOEvent.values()) {
            newIOEventMask.setInterested(ioEvent, this.isInterested(ioEvent) ^ mask.isInterested(ioEvent));
        }
        return newIOEventMask;
    }

    @Override
    public IOEventMask inv() {
        return this.xor(IOEventMask.ALL_EVENTS_MASK);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Interested in: ");
        boolean isAppended = false;
        for (int i = 0; i < this.arrayMask.length; ++i) {
            if (!this.arrayMask[i]) continue;
            if (isAppended) {
                sb.append(',');
            }
            sb.append((Object)IOEvent.values()[i]);
            isAppended = true;
        }
        return sb.toString();
    }
}

