/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LightArrayList<E>
implements List<E> {
    private Object[] array;
    private int size;
    private int offset;

    public LightArrayList() {
        this(16);
    }

    public LightArrayList(int initialCapacity) {
        this.array = new Object[initialCapacity];
    }

    public LightArrayList(List<E> parentList, int fromIndex, int toIndex) {
        this(Math.max(16, toIndex - fromIndex));
        this.size = toIndex - fromIndex;
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = parentList.get(i + fromIndex);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size(int size) {
        int diff = size - this.size;
        if (diff > 0) {
            this.ensureCapacity(size + diff);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.array, this.offset, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.array, this.offset, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.array[this.offset + this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(numNew + this.size);
        System.arraycopy(a, 0, this.array, this.offset + this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(numNew + this.size);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.array, index + this.offset, this.array, index + this.offset + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.array, index + this.offset, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public E remove(int index) {
        Object oldValue = this.array[this.offset + index];
        if (index == this.offset) {
            ++this.offset;
            --this.size;
            return (E)oldValue;
        }
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array, this.offset + index + 1, this.array, this.offset + index, numMoved);
        }
        --this.size;
        return (E)oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.array[index] != null) continue;
                this.remove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.array[index])) continue;
                this.remove(index);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.offset = 0;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        return (E)this.array[index + this.offset];
    }

    @Override
    public E set(int index, E element) {
        int i = index + this.offset;
        Object oldValue = this.array[i];
        this.array[i] = element;
        return (E)oldValue;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.array[i + this.offset] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.array[i + this.offset])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.array[i + this.offset] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.array[i + this.offset])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 < LightArrayList.this.size;
            }

            @Override
            public E next() {
                return LightArrayList.this.get(++this.index);
            }

            @Override
            public void remove() {
                LightArrayList.this.remove(this.index);
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(-1);
    }

    @Override
    public ListIterator<E> listIterator(final int i) {
        return new ListIterator<E>(){
            private int index;
            {
                this.index = i;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < LightArrayList.this.size;
            }

            @Override
            public E next() {
                return LightArrayList.this.get(++this.index);
            }

            @Override
            public boolean hasPrevious() {
                return this.index - 1 >= 0;
            }

            @Override
            public E previous() {
                return LightArrayList.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                LightArrayList.this.remove(this.index);
            }

            @Override
            public void set(E e) {
                LightArrayList.this.set(this.index, e);
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new LightArrayList<E>(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public void ensureCapacity(int newCapacity) {
        int requiredLength = this.offset + newCapacity;
        int diff = requiredLength - this.array.length;
        if (diff <= 0) {
            return;
        }
        if (this.offset >= diff) {
            for (int i = 0; i < this.size; ++i) {
                this.array[i] = this.array[i + this.offset];
            }
            this.offset = 0;
        } else {
            int newLength = Math.max(newCapacity, this.size * 2);
            Object[] newArray = new Object[newLength];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }
}

