/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.util.LinkedTransferQueue;
import org.glassfish.grizzly.util.conditions.Condition;
import org.glassfish.grizzly.util.conditions.ConditionListener;
import org.glassfish.grizzly.util.conditions.DefaultConditionListener;
import org.glassfish.grizzly.util.conditions.EqualCondition;
import org.glassfish.grizzly.util.conditions.NotEqualCondition;
import org.glassfish.grizzly.util.conditions.OneTimeConditionListener;

public class StateHolder<E> {
    private static Logger _logger = Grizzly.logger;
    private volatile E state;
    private final ReentrantReadWriteLock readWriteLock;
    private final boolean isLockEnabled;
    private Collection<ConditionListener<E, ?>> conditionListeners;

    public StateHolder() {
        this(false);
    }

    public StateHolder(boolean isLockEnabled) {
        this.readWriteLock = new ReentrantReadWriteLock();
        this.conditionListeners = new LinkedTransferQueue();
        this.isLockEnabled = isLockEnabled;
    }

    public StateHolder(boolean isLockEnabled, E initialState) {
        this.state = initialState;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.conditionListeners = new LinkedTransferQueue();
        this.isLockEnabled = isLockEnabled;
    }

    public E getState() {
        return this.getState(this.isLockEnabled);
    }

    public E getState(boolean locked) {
        if (locked) {
            this.readWriteLock.readLock().lock();
        }
        E retState = this.state;
        if (locked) {
            this.readWriteLock.readLock().unlock();
        }
        return retState;
    }

    public void setState(E state) {
        this.setState(state, this.isLockEnabled);
    }

    public void setState(E state, boolean locked) {
        if (locked) {
            this.readWriteLock.writeLock().lock();
        }
        this.state = state;
        if (locked) {
            this.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().unlock();
        }
        this.notifyConditionListeners(state);
        if (locked) {
            this.readWriteLock.readLock().unlock();
        }
    }

    public ReentrantReadWriteLock getStateLocker() {
        return this.readWriteLock;
    }

    public boolean isLockEnabled() {
        return this.isLockEnabled;
    }

    public ConditionListener<E, Object> notifyWhenStateIsEqual(E state, Object notificationObject) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        OneTimeConditionListener conditionListener = null;
        if (this.state.equals(state)) {
            DefaultConditionListener.notifyListenerObject(notificationObject);
        } else {
            conditionListener = new OneTimeConditionListener();
            conditionListener.set(new EqualCondition<E>(state), notificationObject);
            this.conditionListeners.add(conditionListener);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
        return conditionListener;
    }

    public ConditionListener<E, Object> notifyWhenStateIsNotEqual(E state, Object notificationObject) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        OneTimeConditionListener conditionListener = null;
        if (!this.state.equals(state)) {
            DefaultConditionListener.notifyListenerObject(notificationObject);
        } else {
            conditionListener = new OneTimeConditionListener();
            conditionListener.set(new NotEqualCondition<E>(state), notificationObject);
            this.conditionListeners.add(conditionListener);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
        return conditionListener;
    }

    public ConditionListener notifyWhenConditionMatchState(Condition<E> condition, Object notificationObject) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        OneTimeConditionListener conditionListener = null;
        if (condition.check(this.state)) {
            DefaultConditionListener.notifyListenerObject(notificationObject);
        } else {
            conditionListener = new OneTimeConditionListener();
            conditionListener.set(condition, notificationObject);
            this.conditionListeners.add(conditionListener);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
        return conditionListener;
    }

    public void addConditionListener(ConditionListener<E, ?> conditionListener) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        if (conditionListener.checkConditionAndNotify(this.state)) {
            if (conditionListener.isKeepAlive()) {
                this.conditionListeners.add(conditionListener);
            }
        } else {
            this.conditionListeners.add(conditionListener);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
    }

    public void removeConditionListener(ConditionListener<E, ?> conditionListener) {
        if (conditionListener == null) {
            return;
        }
        this.conditionListeners.remove(conditionListener);
    }

    protected void notifyConditionListeners(E state) {
        Iterator<ConditionListener<E, ?>> it = this.conditionListeners.iterator();
        while (it.hasNext()) {
            ConditionListener<E, ?> listener = it.next();
            try {
                if (!listener.checkConditionAndNotify(state) || listener.isKeepAlive()) continue;
                it.remove();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error calling ConditionListener", e);
            }
        }
    }
}

