/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.Transport;

public class WorkerThreadExecutor
implements ProcessorExecutor {
    private Transport transport;

    public WorkerThreadExecutor(Transport transport) {
        this.transport = transport;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.transport.getWorkerThreadPool().submit(task);
        }
        catch (RejectedExecutionException e) {
            if (!this.transport.isStopped()) {
                Grizzly.logger.log(Level.WARNING, "Task " + task + " was rejected by ThreadPool. Reason: ", e);
            }
            Grizzly.logger.log(Level.FINE, "Task " + task + " was rejected by ThreadPool. Reason: ", e);
        }
    }

    @Override
    public boolean isCurrentThreadExecutor() {
        return false;
    }
}

