/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util.conditions;

import org.glassfish.grizzly.util.conditions.Condition;

public abstract class ConditionListener<K, L> {
    protected Condition<K> condition;
    protected L notificationObject;
    protected boolean keepAlive = true;

    protected abstract void notifyListener();

    public ConditionListener() {
        this(null, null);
    }

    public ConditionListener(Condition<K> condition, L notificationObject) {
        this.condition = condition;
        this.notificationObject = notificationObject;
    }

    public void set(Condition<K> condition, L notificationObject) {
        this.condition = condition;
        this.notificationObject = notificationObject;
    }

    public Condition<K> getCondition() {
        return this.condition;
    }

    public void setCondition(Condition<K> condition) {
        this.condition = condition;
    }

    public L getNotificationObject() {
        return this.notificationObject;
    }

    public void setNotificationObject(L notificationObject) {
        this.notificationObject = notificationObject;
    }

    public boolean checkConditionAndNotify(K state) {
        if (this.condition.check(state)) {
            this.notifyListener();
            return true;
        }
        return false;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

