/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.ssl.SSLSupport;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.threadpool.ExtendedThreadPool;
import org.glassfish.grizzly.threadpool.WorkerThread;
import org.glassfish.grizzly.web.Constants;
import org.glassfish.grizzly.web.SocketChannelOutputBuffer;
import org.glassfish.grizzly.web.TaskBase;
import org.glassfish.grizzly.web.TaskEvent;
import org.glassfish.grizzly.web.WebFilterConfig;
import org.glassfish.grizzly.web.WebFilterJMXManager;
import org.glassfish.grizzly.web.arp.AsyncHandler;
import org.glassfish.grizzly.web.container.ActionCode;
import org.glassfish.grizzly.web.container.ActionHook;
import org.glassfish.grizzly.web.container.Adapter;
import org.glassfish.grizzly.web.container.Processor;
import org.glassfish.grizzly.web.container.Request;
import org.glassfish.grizzly.web.container.RequestInfo;
import org.glassfish.grizzly.web.container.Response;
import org.glassfish.grizzly.web.container.SuspendedResponse;
import org.glassfish.grizzly.web.container.http11.InputFilter;
import org.glassfish.grizzly.web.container.http11.InternalInputBuffer;
import org.glassfish.grizzly.web.container.http11.OutputFilter;
import org.glassfish.grizzly.web.container.http11.filters.BufferedInputFilter;
import org.glassfish.grizzly.web.container.http11.filters.ChunkedInputFilter;
import org.glassfish.grizzly.web.container.http11.filters.ChunkedOutputFilter;
import org.glassfish.grizzly.web.container.http11.filters.GzipOutputFilter;
import org.glassfish.grizzly.web.container.http11.filters.IdentityInputFilter;
import org.glassfish.grizzly.web.container.http11.filters.IdentityOutputFilter;
import org.glassfish.grizzly.web.container.http11.filters.VoidInputFilter;
import org.glassfish.grizzly.web.container.http11.filters.VoidOutputFilter;
import org.glassfish.grizzly.web.container.util.Interceptor;
import org.glassfish.grizzly.web.container.util.buf.Ascii;
import org.glassfish.grizzly.web.container.util.buf.ByteChunk;
import org.glassfish.grizzly.web.container.util.buf.HexUtils;
import org.glassfish.grizzly.web.container.util.buf.MessageBytes;
import org.glassfish.grizzly.web.container.util.http.FastHttpDateFormat;
import org.glassfish.grizzly.web.container.util.http.MimeHeaders;
import org.glassfish.grizzly.web.container.util.res.StringManager;

public class ProcessorTask
extends TaskBase
implements Processor,
ActionHook {
    private static final Logger logger = Grizzly.logger;
    protected static final StringManager sm = StringManager.getManager("org.glassfish.grizzly.web.res");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected StreamReader inputStream = null;
    protected StreamWriter outputStream = null;
    protected SocketChannelOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean connectionHeaderValueSet = false;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected SSLSupport sslSupport;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int uploadTimeout = 300000;
    protected int maxPostSize = 0x200000;
    protected char[] hostNameC = new char[0];
    protected boolean hasRequestInfoRegistered = false;
    protected int maxHttpHeaderSize = 8192;
    protected static int requestCount;
    protected int requestBufferSize = 8192;
    protected ObjectName oname;
    protected boolean dropConnection = false;
    protected int keepAliveLeft;
    private Interceptor handler;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected boolean asyncExecution = false;
    protected RequestInfo requestInfo;
    protected AsyncHandler asyncHandler;
    protected FilterChainContext filterChainContext;
    private Semaphore asyncSemaphore = new Semaphore(1);
    protected String[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected String[] restrictedUserAgents = null;
    protected boolean bufferResponse = true;
    protected boolean disableUploadTimeout = true;
    protected boolean isAsyncHttpWriteEnabled;
    private int transactionTimeout = 300000;
    private boolean useChunking = true;
    private static final String USE_KEEP_ALIVE = "org.glassfish.grizzly.web.useKeepAliveAlgorithm";
    private static final String BLOCKING_KEEP_ALIVE = "org.glassfish.grizzly.web.keepAliveLockingThread";
    private boolean useKeepAliveAlgorithm = true;
    protected int maxKeepAliveRequests = 256;
    protected boolean handleKeepAliveBlockingThread = false;

    public ProcessorTask() {
        this(true);
    }

    public ProcessorTask(boolean init) {
        if (init) {
            this.initialize();
        }
    }

    public ProcessorTask(boolean init, boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
        if (init) {
            this.initialize();
        }
    }

    public void initialize() {
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new SocketChannelOutputBuffer(this.response, this.maxHttpHeaderSize, this.bufferResponse);
        this.request.setInputBuffer(this.inputBuffer);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
        if (System.getProperty(USE_KEEP_ALIVE) != null) {
            this.useKeepAliveAlgorithm = Boolean.valueOf(System.getProperty(USE_KEEP_ALIVE));
            if (!this.useKeepAliveAlgorithm) {
                logger.info("Keep Alive algorith will no be used");
            }
        }
        if (System.getProperty(BLOCKING_KEEP_ALIVE) != null) {
            this.handleKeepAliveBlockingThread = Boolean.valueOf(System.getProperty(BLOCKING_KEEP_ALIVE));
            if (!this.handleKeepAliveBlockingThread) {
                logger.info("Keep Alive blocking thread algorithm will no be used");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask() throws IOException {
        try {
            this.process(this.inputStream, this.outputStream);
        }
        catch (Throwable ex) {
            logger.log(Level.FINE, sm.getString("processorTask.errorProcessingRequest"), ex);
        }
        finally {
            this.terminateProcess();
        }
    }

    public void preProcess() throws Exception {
        this.preProcess(this.inputStream, this.outputStream);
    }

    public void preProcess(StreamReader input, StreamWriter output) throws Exception {
        if (!this.started) {
            this.initialize();
        }
        this.inputBuffer.setInputStream(input);
        this.inputStream = input;
        this.outputBuffer.setStreamWriter(output);
        this.outputBuffer.setAsyncHttpWriteEnabled(this.isAsyncHttpWriteEnabled);
        this.response.setConnection(input.getConnection());
        this.response.setStreamWriter(output);
        this.configPreProcess();
    }

    protected void configPreProcess() throws Exception {
        boolean isMonitoringEnabled = ((WebFilterConfig)this.webFilter.getConfig()).isMonitoringEnabled();
        if (isMonitoringEnabled && !this.hasRequestInfoRegistered) {
            this.registerMonitoring();
        } else if (!isMonitoringEnabled && this.hasRequestInfoRegistered) {
            this.unregisterMonitoring();
        }
        if (isMonitoringEnabled) {
            this.requestInfo = this.request.getRequestProcessor();
            this.requestInfo.setWorkerThreadID(Thread.currentThread().getId());
        }
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localName = null;
        this.localAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.connectionHeaderValueSet = false;
        this.error = false;
        this.keepAlive = true;
        if (this.request.getServerPort() == 0) {
            this.request.setServerPort(((InetSocketAddress)this.connection.getLocalAddress()).getPort());
        }
    }

    protected boolean doProcess() throws Exception {
        if (!this.handleKeepAliveBlockingThread) {
            boolean exitWhile = this.parseRequest();
            if (exitWhile) {
                return exitWhile;
            }
            this.invokeAdapter();
            this.postResponse();
        } else {
            int soTimeout = (int)this.inputStream.getTimeout(TimeUnit.MILLISECONDS);
            ExtendedThreadPool st = (ExtendedThreadPool)((Object)this.getThreadPool());
            if (this.useKeepAliveAlgorithm) {
                float threadRatio = (float)st.getActiveCount() / (float)st.getMaximumPoolSize();
                if ((double)threadRatio > 0.33 && (double)threadRatio <= 0.66) {
                    soTimeout /= 2;
                } else if ((double)threadRatio > 0.66) {
                    soTimeout /= 5;
                    this.keepAliveLeft = 1;
                }
                this.inputStream.setTimeout(soTimeout, TimeUnit.MILLISECONDS);
            }
            while (this.started && !this.error && this.keepAlive) {
                boolean exitWhile = this.parseRequest();
                if (this.maxKeepAliveRequests > 0 && --this.keepAliveLeft == 0) {
                    this.keepAlive = false;
                }
                if (exitWhile) {
                    return exitWhile;
                }
                this.invokeAdapter();
                this.postResponse();
            }
        }
        return this.error;
    }

    public void postResponse() throws Exception {
        if (this.response.isSuspended()) {
            SuspendedResponse suspendedResponse = this.response.getSuspendedResponse();
            ScheduledFuture<?> future = ((WebFilterConfig)this.webFilter.getConfig()).getScheduledThreadPool().schedule(suspendedResponse, suspendedResponse.getTimeout(), TimeUnit.MILLISECONDS);
            suspendedResponse.setFuture(future);
            return;
        }
        if (((WebFilterConfig)this.webFilter.getConfig()).isMonitoringEnabled()) {
            this.request.updateCounters();
        }
        try {
            this.adapter.afterService(this.request, this.response);
        }
        catch (Exception ex) {
            this.error = true;
            logger.log(Level.FINEST, sm.getString("processorTask.errorFinishingRequest"), ex);
        }
        try {
            if (this.error) {
                this.inputBuffer.setSwallowInput(false);
            }
            this.inputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFinishingRequest"), t);
            this.response.setStatus(500);
            this.error = true;
        }
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFinishingResponse"), t);
            this.error = true;
        }
        if (this.error) {
            this.response.setStatus(500);
        }
        this.inputBuffer.nextRequest();
        this.outputBuffer.nextRequest();
    }

    public void invokeAdapter() {
        if (!this.error) {
            try {
                this.adapter.service(this.request, this.response);
                if (this.keepAlive && !this.error) {
                    this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                }
            }
            catch (InterruptedIOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, sm.getString("processorTask.serviceError"), t);
                this.response.setStatus(500);
                this.error = true;
            }
        }
    }

    public boolean parseRequest() throws Exception {
        try {
            this.inputBuffer.parseRequestLine();
            if (((WebFilterConfig)this.webFilter.getConfig()).isMonitoringEnabled()) {
                this.request.getRequestProcessor().setRequestCompletionTime(0L);
            }
            this.request.setStartTime(System.currentTimeMillis());
            if (this.getHandler() != null && this.getHandler().handle(this.request, 0) == 1) {
                return true;
            }
            if (!this.disableUploadTimeout && this.getConnection() != null) {
                this.inputStream.setTimeout(this.uploadTimeout, TimeUnit.MILLISECONDS);
            }
            WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
            workerThread.setTransactionTimeout(this.transactionTimeout, TimeUnit.MILLISECONDS);
            this.inputBuffer.parseHeaders();
            if (((WebFilterConfig)this.webFilter.getConfig()).isEnableNioLogging()) {
                logger.log(Level.INFO, "Connection request line" + this.connection + " is: " + this.request);
                logger.log(Level.INFO, "Connection headers" + this.connection + " are: " + this.request.getMimeHeaders());
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, sm.getString("processorTask.nonBlockingError"), e);
            }
            this.error = true;
            this.keepAlive = false;
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, sm.getString("processorTask.nonBlockingError"), t);
            this.response.setStatus(400);
            this.error = true;
        }
        try {
            this.prepareRequest();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, sm.getString("processorTask.createRequestError"), t);
            }
            this.response.setStatus(400);
            this.error = true;
        }
        return false;
    }

    public void postProcess() throws Exception {
        if (this.response.isSuspended()) {
            return;
        }
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
        if (this.error) {
            this.keepAlive = false;
            this.connectionHeaderValueSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateProcess() {
        try {
            if (this.asyncSemaphore.tryAcquire(0L, TimeUnit.SECONDS)) {
                if (this.getTaskListener() == null) {
                    return;
                }
                TaskEvent<ProcessorTask> event = new TaskEvent<ProcessorTask>();
                if (this.error) {
                    event.setStatus(1);
                } else {
                    event.setStatus(2);
                }
                event.attach(this);
                this.getTaskListener().taskEvent(event);
                event.attach(null);
            }
        }
        catch (InterruptedException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, sm.getString("terminateProcess"), ex);
            }
        }
        finally {
            this.asyncSemaphore.release();
        }
    }

    @Override
    public boolean process(StreamReader input, StreamWriter output) throws Exception {
        this.preProcess(input, output);
        this.doProcess();
        this.postProcess();
        return this.keepAlive;
    }

    public String getRequestURI() {
        return this.request.requestURI().toString();
    }

    @Override
    public void action(ActionCode actionCode, Object param) {
        block71: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException ex) {
                    logger.log(Level.FINEST, sm.getString("processorTask.nonBlockingError"), ex);
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted() || !this.http11) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    logger.log(Level.FINEST, sm.getString("processorTask.nonBlockingError"), e);
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block71;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, sm.getString("processorTask.errorSSL"), e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteAddr == null && this.connection != null && (inetAddr = ((InetSocketAddress)this.connection.getPeerAddress()).getAddress()) != null) {
                        this.remoteAddr = inetAddr.getHostAddress();
                    }
                    this.request.remoteAddr().setString(this.remoteAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.connection != null && (inetAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    if (this.remoteHost == null && this.connection != null) {
                        InetAddress inetAddr = ((InetSocketAddress)this.connection.getPeerAddress()).getAddress();
                        if (inetAddr != null) {
                            this.remoteHost = inetAddr.getHostName();
                        }
                        if (this.remoteHost == null) {
                            if (this.remoteAddr != null) {
                                this.remoteHost = this.remoteAddr;
                            } else {
                                this.request.remoteHost().recycle();
                            }
                        }
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.connection != null) {
                        this.remotePort = ((InetSocketAddress)this.connection.getPeerAddress()).getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.connection != null) {
                        this.localPort = ((InetSocketAddress)this.connection.getLocalAddress()).getPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                    if (this.sslSupport != null) {
                        InputFilter[] inputFilters = this.inputBuffer.getFilters();
                        ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                        this.inputBuffer.addActiveFilter(inputFilters[3]);
                        try {
                            Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                            if (sslO != null) {
                                this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, sm.getString("processorTask.exceptionSSLcert"), e);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_POST_REQUEST) {
                    if (this.response.getStatus() == 200 && this.getHandler() != null && this.compressionLevel == 0) {
                        try {
                            this.getHandler().handle(this.request, 1);
                        }
                        catch (IOException ex) {
                            logger.log(Level.FINEST, "Handler exception", ex);
                        }
                    }
                } else if (actionCode != ActionCode.CANCEL_SUSPENDED_RESPONSE) {
                    if (actionCode == ActionCode.RESET_SUSPEND_TIMEOUT) {
                        SuspendedResponse suspendedResponse = this.response.getSuspendedResponse();
                        if (suspendedResponse != null && suspendedResponse.getFuture() != null) {
                            suspendedResponse.getFuture().cancel(false);
                            suspendedResponse.setFuture(((WebFilterConfig)this.webFilter.getConfig()).getScheduledThreadPool().schedule(suspendedResponse, suspendedResponse.getTimeout(), TimeUnit.MILLISECONDS));
                        }
                    } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH && this.connection != null) {
                        try {
                            this.outputBuffer.flush();
                        }
                        catch (IOException ex) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.log(Level.FINEST, "ACTION_CLIENT_FLUSH", ex);
                            }
                            this.error = true;
                            this.response.setErrorException(ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
                this.connectionHeaderValueSet = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
                this.connectionHeaderValueSet = true;
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].equals(userAgentValue)) continue;
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        long contentLength = this.request.getContentLengthLong();
        if (contentLength >= 0L) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(((InetSocketAddress)this.connection.getLocalAddress()).getPort());
            InetAddress localAddress = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            } else {
                headers.setValue("Content-Type").setString(this.defaultResponseType);
            }
            String contentLanguage = this.response.getContentLanguage();
            if (contentLanguage != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            headers.setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (this.useChunking && entityBody && this.http11 && this.keepAlive) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            this.response.setHeader("Content-Encoding", "gzip");
            this.response.setHeader("Vary", "Accept-Encoding");
        }
        if (!this.response.containsHeader("Date")) {
            String date = FastHttpDateFormat.getCurrentDate();
            this.response.addHeader("Date", date);
        }
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode) && !this.dropConnection;
        if (!this.keepAlive) {
            headers.setValue("Connection").setString("close");
            this.connectionHeaderValueSet = false;
        } else if (!this.http11 && !this.error) {
            headers.setValue("Connection").setString("Keep-Alive");
        }
        this.outputBuffer.sendStatus();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                logger.log(Level.WARNING, sm.getString("processorTask.unknownFilter"), className);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, sm.getString("processorTask.errorFilter"), new Object[]{className, e});
        }
    }

    public void setMaxPostSize(int mps) {
        this.maxPostSize = mps;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setTimeout(int timeouts) {
        this.uploadTimeout = timeouts;
    }

    public int getTimeout() {
        return this.uploadTimeout;
    }

    public boolean isAsyncHttpWriteEnabled() {
        return this.isAsyncHttpWriteEnabled;
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.isAsyncHttpWriteEnabled = isAsyncHttpWriteEnabled;
    }

    private void registerMonitoring() {
        WebFilterJMXManager jmxManager = this.webFilter.getJmxManager();
        if (jmxManager == null) {
            return;
        }
        this.requestInfo = this.request.getRequestProcessor();
        this.requestInfo.setGlobalProcessor(this.webFilter.getRequestGroupInfo());
        try {
            this.oname = new ObjectName(jmxManager.getDomain() + ":type=RequestProcessor,worker=http" + this.webFilter.getName() + ",name=HttpRequest" + requestCount++);
            jmxManager.registerComponent(this.requestInfo, this.oname, null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, sm.getString("processorTask.errorRegisteringRequest"), ex);
        }
        this.hasRequestInfoRegistered = true;
    }

    protected void unregisterMonitoring() {
        WebFilterJMXManager jmxManager = this.webFilter.getJmxManager();
        if (jmxManager == null) {
            return;
        }
        this.requestInfo = this.request.getRequestProcessor();
        this.requestInfo.setGlobalProcessor(null);
        this.requestInfo.reset();
        if (this.oname != null) {
            try {
                jmxManager.unregisterComponent(this.oname);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, sm.getString("processorTask.errorUnregisteringRequest"), ex);
            }
        }
        this.hasRequestInfoRegistered = false;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public void setDropConnection(boolean dropConnection) {
        this.dropConnection = dropConnection;
    }

    public boolean getDropConnection() {
        return this.dropConnection;
    }

    public void setHandler(Interceptor handler) {
        this.handler = handler;
    }

    public Interceptor getHandler() {
        return this.handler;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
    }

    public boolean isAsyncExecutionEnabled() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public void recycle() {
        this.setTaskListener(null);
        this.filterChainContext = null;
        this.connection = null;
        this.dropConnection = false;
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void addNoCompressionUserAgent(String userAgent) {
        this.noCompressionUserAgents = this.addStringArray(this.noCompressionUserAgents, userAgent);
    }

    public void setNoCompressionUserAgents(String[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String[] findNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public void setCompressableMimeType(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    private String[] addStringArray(String[] sArray, String value) {
        if (value == null) {
            return sArray != null ? sArray : new String[]{};
        }
        if (sArray == null) {
            sArray = new String[]{value};
            return sArray;
        }
        String[] results = new String[sArray.length + 1];
        for (int i = 0; i < sArray.length; ++i) {
            results[i] = sArray[i];
        }
        results[sArray.length] = value;
        return results;
    }

    private boolean inStringArray(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isCompressable() {
        String userAgentValue;
        MessageBytes userAgentValueMB;
        if (!this.http11) {
            return false;
        }
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1 && acceptEncodingMB.indexOf("deflate") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && (contentEncodingMB.indexOf("gzip") != -1 || contentEncodingMB.indexOf("deflate") != -1)) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null && this.inStringArray(this.noCompressionUserAgents, userAgentValue = userAgentValueMB.toString())) {
            return false;
        }
        int contentLength = this.response.getContentLength();
        if ((contentLength == -1 || contentLength > this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void addRestrictedUserAgent(String userAgent) {
        this.restrictedUserAgents = this.addStringArray(this.restrictedUserAgents, userAgent);
    }

    public void setRestrictedUserAgents(String[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String[] findRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public SSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public long getWorkerThreadID() {
        return this.request.getRequestProcessor().getWorkerThreadID();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setConnectionHeaderValueSet(boolean connectionHeaderValueSet) {
        this.connectionHeaderValueSet = connectionHeaderValueSet;
    }

    public boolean isError() {
        return this.error;
    }

    public StreamReader getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(StreamReader inputStream) {
        this.inputStream = inputStream;
    }

    public StreamWriter getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(StreamWriter streamWriter) {
        this.outputStream = streamWriter;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public FilterChainContext getFilterChainContext() {
        return this.filterChainContext;
    }

    public void setFilterChainContext(FilterChainContext filterChainContext) {
        this.filterChainContext = filterChainContext;
    }
}

