/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.container.util.collections;

import org.glassfish.grizzly.web.container.util.buf.MessageBytes;

public class MultiMap {
    protected Field[] fields;
    protected int count;
    static final int NEED_NEXT = -2;
    static final int LAST = -1;

    public MultiMap(int initial_size) {
        this.fields = new Field[initial_size];
    }

    public void recycle() {
        for (int i = 0; i < this.count; ++i) {
            this.fields[i].recycle();
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n) {
        return this.fields[n].name;
    }

    public MessageBytes getValue(int n) {
        return this.fields[n].value;
    }

    public int find(String name, int starting) {
        for (int i = starting; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findIgnoreCase(String name, int starting) {
        for (int i = starting; i < this.count; ++i) {
            if (!this.fields[i].name.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public void remove(int i) {
        Field mh = this.fields[i];
        mh.recycle();
        this.fields[i] = this.fields[this.count - 1];
        this.fields[this.count - 1] = mh;
        --this.count;
    }

    public int addField() {
        int len = this.fields.length;
        int pos = this.count;
        if (this.count >= len) {
            Field[] tmp = new Field[pos * 2];
            System.arraycopy(this.fields, 0, tmp, 0, len);
            this.fields = tmp;
        }
        if (this.fields[pos] == null) {
            this.fields[pos] = new Field();
        }
        ++this.count;
        return pos;
    }

    public MessageBytes get(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            return this.fields[i].value;
        }
        return null;
    }

    public int findFirst(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findNext(int startPos) {
        int next = this.fields[startPos].nextPos;
        if (next != -2) {
            return next;
        }
        MessageBytes name = this.fields[startPos].name;
        for (int i = startPos; i < this.count; ++i) {
            if (!this.fields[i].name.equals(name)) continue;
            this.fields[startPos].nextPos = i;
            return i;
        }
        this.fields[startPos].nextPos = -1;
        return -1;
    }

    final class Field {
        MessageBytes name;
        MessageBytes value;
        int nextPos = -2;

        Field() {
        }

        void recycle() {
            this.name.recycle();
            this.value.recycle();
            this.nextPos = -2;
        }
    }
}

