/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.container.util.net;

import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.web.container.util.LoggerUtils;
import org.glassfish.grizzly.web.container.util.net.SSLSupport;
import org.glassfish.grizzly.web.container.util.net.ServerSocketFactory;
import org.glassfish.grizzly.web.container.util.net.jsse.JSSEImplementation;

public abstract class SSLImplementation {
    private static final Logger logger = LoggerUtils.getLogger();
    private static final String JSSEImplementationClass = "org.glassfish.grizzly.web.container.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.glassfish.grizzly.web.container.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (int i = 0; i < implementations.length; ++i) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Error creating " + implementations[i], e);
                continue;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            if (JSSEImplementationClass.equals(className)) {
                return new JSSEImplementation();
            }
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Error loading SSL Implementation " + className, e);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory();

    public abstract SSLSupport getSSLSupport(Socket var1);

    public abstract SSLSupport getSSLSupport(SSLEngine var1);
}

