/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.web.container.http11.GrizzlyRequest;
import org.glassfish.grizzly.web.container.http11.GrizzlySession;
import org.glassfish.grizzly.web.container.util.LoggerUtils;
import org.glassfish.grizzly.web.container.util.res.StringManager;
import org.glassfish.grizzly.web.servlet.CookieWrapper;
import org.glassfish.grizzly.web.servlet.HttpSessionImpl;
import org.glassfish.grizzly.web.servlet.ServletContextImpl;
import org.glassfish.grizzly.web.servlet.ServletInputStreamImpl;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private ServletInputStream inputStream = null;
    private HttpSessionImpl httpSession = null;
    private ServletContextImpl contextImpl;
    private String servletPath = "";
    private Logger logger = LoggerUtils.getLogger();
    protected static final StringManager sm = StringManager.getManager("org.glassfish.grizzly.web.container.http11");
    protected GrizzlyRequest request = null;

    public HttpServletRequestImpl(GrizzlyRequest request) throws IOException {
        this.request = request;
        this.inputStream = new ServletInputStreamImpl(request.createInputStream());
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.request = null;
    }

    @Override
    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.request.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        this.request.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentLength();
    }

    @Override
    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.inputStream;
    }

    @Override
    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    @Override
    public Enumeration getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.request.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String[] ret = null;
        if (System.getSecurityManager() != null) {
            ret = (String[])AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    @Override
    public Map getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Map)AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    @Override
    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getProtocol();
    }

    @Override
    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getReader();
    }

    @Override
    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        Object oldValue = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletRequestAttributeEvent(this.contextImpl, this, name, oldValue) : new ServletRequestAttributeEvent(this.contextImpl, this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String value = (String)this.request.getAttribute(name);
        this.request.removeAttribute(name);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = new ServletRequestAttributeEvent(this.contextImpl, this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    @Override
    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Locale)AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    @Override
    public Enumeration getLocales() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.request.getLocales();
    }

    @Override
    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getRealPath(String path) {
        return this.contextImpl.getRealPath(path);
    }

    @Override
    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAuthType();
    }

    public org.glassfish.grizzly.web.container.util.http.Cookie[] getGrizzlyCookies() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        org.glassfish.grizzly.web.container.util.http.Cookie[] ret = null;
        if (System.getSecurityManager() != null) {
            ret = (org.glassfish.grizzly.web.container.util.http.Cookie[])AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (org.glassfish.grizzly.web.container.util.http.Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    @Override
    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getHeader(name);
    }

    @Override
    public Enumeration getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return this.request.getHeaders(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.request.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getIntHeader(name);
    }

    @Override
    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getMethod();
    }

    @Override
    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String path = this.request.getRequestURI();
        StringBuilder pathToRemove = new StringBuilder();
        pathToRemove.append(this.contextImpl.getContextPath());
        pathToRemove.append(this.getServletPath());
        String s = pathToRemove.toString();
        if (path.startsWith(s)) {
            return path.substring(s.length());
        }
        throw new IllegalStateException("Request path not in servlet context.");
    }

    @Override
    public String getPathTranslated() {
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.contextImpl.getRealPath(this.getPathInfo());
    }

    @Override
    public String getContextPath() {
        return this.contextImpl.getContextPath();
    }

    @Override
    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURL();
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    protected void initSession() {
        GrizzlySession session = this.request.getSession(false);
        if (session != null) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
            this.httpSession.notifyNew();
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
    }

    @Override
    public HttpSession getSession(boolean create) {
        GrizzlySession session;
        if (this.httpSession == null && create) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
        }
        if (this.httpSession != null && (session = this.request.getSession(create)) != null) {
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
        return this.httpSession;
    }

    @Override
    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    @Override
    public Cookie[] getCookies() {
        org.glassfish.grizzly.web.container.util.http.Cookie[] internalCookies = this.request.getCookies();
        if (internalCookies == null) {
            return null;
        }
        Cookie[] cookies = new Cookie[internalCookies.length];
        for (int i = 0; i < internalCookies.length; ++i) {
            org.glassfish.grizzly.web.container.util.http.Cookie cook = internalCookies[i];
            if (cook instanceof CookieWrapper) {
                cookies[i] = ((CookieWrapper)internalCookies[i]).getWrappedCookie();
                continue;
            }
            cookies[i] = new Cookie(cook.getName(), cook.getValue());
            cookies[i].setComment(cook.getComment());
            if (cook.getDomain() != null) {
                cookies[i].setDomain(cook.getDomain());
            }
            cookies[i].setMaxAge(cook.getMaxAge());
            cookies[i].setPath(cook.getPath());
            cookies[i].setSecure(cook.getSecure());
            cookies[i].setVersion(cook.getVersion());
        }
        return cookies;
    }

    @Override
    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemotePort();
    }

    @Override
    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalName();
    }

    @Override
    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalPort();
    }

    protected ServletContextImpl getContextImpl() {
        return this.contextImpl;
    }

    protected void setContextImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    protected void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction {
        private boolean create;

        public GetSessionPrivilegedAction(boolean create) {
            this.create = create;
        }

        public Object run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction {
        private GetLocalesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocales();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction {
        private GetLocalePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction {
        private GetHeaderNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaderNames();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction {
        private String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaders(this.name);
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction {
        private GetCharacterEncodingPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction {
        private GetCookiesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction {
        private GetParameterNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction {
        private String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        public Object run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction {
        private GetParameterMapPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction {
        private GetAttributePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getAttributeNames();
        }
    }
}

