/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.web.container.http11.GrizzlyResponse;
import org.glassfish.grizzly.web.container.util.res.StringManager;
import org.glassfish.grizzly.web.servlet.CookieWrapper;
import org.glassfish.grizzly.web.servlet.ServletOutputStreamImpl;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private ServletOutputStream outputStream = null;
    protected static final StringManager sm = StringManager.getManager("org.glassfish.grizzly.web.container.http11");
    protected GrizzlyResponse response = null;

    public HttpServletResponseImpl(GrizzlyResponse response) throws IOException {
        this.response = response;
        this.outputStream = new ServletOutputStreamImpl(response.createOutputStream());
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.response = null;
    }

    public void finish() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.isBufferSuspended();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return this.outputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = this.response.getWriter();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return writer;
    }

    @Override
    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    @Override
    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type));
        } else {
            this.response.setContentType(type);
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        HttpServletResponseImpl.this.response.setAppCommitted(true);
                        HttpServletResponseImpl.this.response.flushBuffer();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) return;
                throw (IOException)ex;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.isAppCommitted();
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        CookieWrapper wrapper = new CookieWrapper(cookie.getName(), cookie.getValue());
        wrapper.setWrappedCookie(cookie);
        this.response.addCookie(wrapper);
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String encodeUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String encodeRedirectUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("HttpServletResponseImpl.nullResponse"));
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    @Override
    public void setStatus(int sc, String sm) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc, sm);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getMessage() {
        return this.response.getMessage();
    }

    public void setSuspended(boolean suspended) {
        this.response.setSuspended(suspended);
    }

    public void setAppCommitted(boolean appCommitted) {
        this.response.setAppCommitted(appCommitted);
    }

    public int getContentCount() {
        return this.response.getContentCount();
    }

    public boolean isError() {
        return this.response.isError();
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public void setCharacterEncoding(String charEnc) {
        this.response.setCharacterEncoding(charEnc);
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction {
        private String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        public Object run() {
            HttpServletResponseImpl.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

