/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.servlet;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.glassfish.grizzly.web.container.http11.GrizzlySession;
import org.glassfish.grizzly.web.container.util.LoggerUtils;
import org.glassfish.grizzly.web.servlet.ServletContextImpl;

public class HttpSessionImpl
implements HttpSession {
    private GrizzlySession session;
    private ServletContextImpl contextImpl;
    private Long creationTime;
    private Long lastAccessed;
    private boolean isNew = true;

    public HttpSessionImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
        this.lastAccessed = this.creationTime = Long.valueOf(System.currentTimeMillis());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.session.getIdInternal();
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    protected void access() {
        this.lastAccessed = System.currentTimeMillis();
        this.session.setTimestamp(this.lastAccessed);
        this.isNew = false;
    }

    @Override
    public ServletContext getServletContext() {
        return this.contextImpl;
    }

    @Override
    public void setMaxInactiveInterval(int sessionTimeout) {
        this.session.setTimestamp(sessionTimeout);
    }

    @Override
    public int getMaxInactiveInterval() {
        return (int)this.session.getSessionTimeout();
    }

    @Override
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    @Override
    public Object getValue(String value) {
        return this.session.getAttribute(value);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.session.atttibutes().keys();
    }

    @Override
    public String[] getValueNames() {
        return this.session.atttibutes().entrySet().toArray(new String[0]);
    }

    @Override
    public void setAttribute(String key, Object value) {
        List<EventListener> listeners;
        if (value == null) {
            this.removeAttribute(key);
            return;
        }
        Object unbound = this.session.getAttribute(key);
        this.session.setAttribute(key, value);
        if (unbound != null && unbound != value && unbound instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this, key));
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.WARNING, "", t);
            }
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener && value != unbound) {
            event = new HttpSessionBindingEvent(this, key, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.WARNING, "", t);
            }
        }
        if ((listeners = this.contextImpl.getListeners()).size() == 0) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.get(i);
            try {
                if (unbound != null) {
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this, key, unbound);
                    }
                    listener.attributeReplaced(event);
                    continue;
                }
                if (event == null) {
                    event = new HttpSessionBindingEvent(this, key, value);
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.WARNING, "", t);
            }
        }
    }

    @Override
    public void putValue(String key, Object value) {
        this.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        List<EventListener> listeners;
        Object value = this.session.removeAttribute(key);
        if (value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this, key, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = this.contextImpl.getListeners()).size() == 0) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = new HttpSessionBindingEvent(this, key, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.WARNING, "", t);
            }
        }
    }

    @Override
    public void removeValue(String key) {
        this.removeAttribute(key);
    }

    @Override
    public synchronized void invalidate() {
        this.session.atttibutes().clear();
        this.creationTime = 0L;
        this.isNew = true;
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() > 0) {
            HttpSessionEvent event = new HttpSessionEvent(this);
            for (int i = 0; i < listeners.size(); ++i) {
                EventListener listenerObj = listeners.get(i);
                int j = listeners.size() - 1 - i;
                if (!(listenerObj instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listenerObj;
                try {
                    listener.sessionDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
        }
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    protected void setSession(GrizzlySession session) {
        this.session = session;
    }

    protected void notifyNew() {
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() > 0) {
            HttpSessionEvent event = new HttpSessionEvent(this);
            for (int i = 0; i < listeners.size(); ++i) {
                EventListener listenerObj = listeners.get(i);
                if (!(listenerObj instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listenerObj;
                try {
                    listener.sessionCreated(event);
                    continue;
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
        }
    }
}

