/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;

public class ActiveDescriptorBuilderImpl
implements ActiveDescriptorBuilder {
    private String name;
    private final HashSet<Type> contracts = new HashSet();
    private Class<? extends Annotation> scope = PerLookup.class;
    private final HashSet<Annotation> qualifiers = new HashSet();
    private final HashMap<String, List<String>> metadatas = new HashMap();
    private final Class<?> implementation;
    private HK2Loader loader = null;
    private int rank = 0;
    private Boolean proxy = null;
    private Boolean proxyForSameScope = null;
    private DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
    private String classAnalysisName = null;

    public ActiveDescriptorBuilderImpl(Class<?> implementation) {
        this.implementation = implementation;
    }

    @Override
    public ActiveDescriptorBuilder named(String name) throws IllegalArgumentException {
        this.name = name;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder to(Type contract) throws IllegalArgumentException {
        if (contract != null) {
            this.contracts.add(contract);
        }
        return this;
    }

    @Override
    public ActiveDescriptorBuilder in(Class<? extends Annotation> scope) throws IllegalArgumentException {
        this.scope = scope;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder qualifiedBy(Annotation annotation) throws IllegalArgumentException {
        if (annotation != null) {
            this.qualifiers.add(annotation);
        }
        return this;
    }

    @Override
    public ActiveDescriptorBuilder has(String key, String value) throws IllegalArgumentException {
        return this.has(key, Collections.singletonList(value));
    }

    @Override
    public ActiveDescriptorBuilder has(String key, List<String> values) throws IllegalArgumentException {
        if (key == null || values == null || values.size() <= 0) {
            throw new IllegalArgumentException();
        }
        this.metadatas.put(key, values);
        return this;
    }

    @Override
    public ActiveDescriptorBuilder ofRank(int rank) {
        this.rank = rank;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder proxy() {
        return this.proxy(true);
    }

    @Override
    public ActiveDescriptorBuilder proxy(boolean forceProxy) {
        this.proxy = forceProxy ? Boolean.TRUE : Boolean.FALSE;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder proxyForSameScope() {
        return this.proxy(true);
    }

    @Override
    public ActiveDescriptorBuilder proxyForSameScope(boolean forceProxyForSameScope) {
        this.proxyForSameScope = forceProxyForSameScope ? Boolean.TRUE : Boolean.FALSE;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder andLoadWith(HK2Loader loader) throws IllegalArgumentException {
        this.loader = loader;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder analyzeWith(String serviceName) {
        this.classAnalysisName = serviceName;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder localOnly() {
        this.visibility = DescriptorVisibility.LOCAL;
        return this;
    }

    @Override
    public ActiveDescriptorBuilder visibility(DescriptorVisibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException();
        }
        this.visibility = visibility;
        return this;
    }

    @Override
    public <T> AbstractActiveDescriptor<T> build() throws IllegalArgumentException {
        return new BuiltActiveDescriptor(this.implementation, this.contracts, this.scope, this.name, this.qualifiers, DescriptorType.CLASS, this.visibility, this.rank, this.proxy, this.proxyForSameScope, this.classAnalysisName, this.metadatas, this.loader);
    }

    @Override
    @Deprecated
    public <T> AbstractActiveDescriptor<T> buildFactory() throws IllegalArgumentException {
        return this.buildProvideMethod();
    }

    @Override
    public <T> AbstractActiveDescriptor<T> buildProvideMethod() throws IllegalArgumentException {
        return new BuiltActiveDescriptor(this.implementation, this.contracts, this.scope, this.name, this.qualifiers, DescriptorType.PROVIDE_METHOD, this.visibility, this.rank, this.proxy, this.proxyForSameScope, this.classAnalysisName, this.metadatas, this.loader);
    }

    private static class BuiltActiveDescriptor<T>
    extends AbstractActiveDescriptor<T> {
        private static final long serialVersionUID = 2434137639270026082L;
        private final Class<?> implementationClass;

        private BuiltActiveDescriptor(Class<?> implementationClass, Set<Type> advertisedContracts, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, DescriptorType descriptorType, DescriptorVisibility descriptorVisibility, int ranking, Boolean proxy, Boolean proxyForSameScope, String classAnalysisName, Map<String, List<String>> metadata, HK2Loader loader) {
            super(advertisedContracts, scope, name, qualifiers, descriptorType, descriptorVisibility, ranking, proxy, proxyForSameScope, classAnalysisName, metadata);
            super.setReified(false);
            super.setLoader(loader);
            this.implementationClass = implementationClass;
            super.setImplementation(implementationClass.getName());
        }

        @Override
        public Class<?> getImplementationClass() {
            return this.implementationClass;
        }

        @Override
        public T create(ServiceHandle<?> root) {
            throw new AssertionError((Object)"Should not be called directly");
        }
    }
}

