/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;

public final class PythonCextStructSeqBuiltins {

    static abstract class PyStructSequence_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyStructSequence_New() {
        }

        @Specialization
        static Object doGeneric(Object cls, @Bind(value="this") Node inliningTarget, @Cached(value="createForceType()") ReadAttributeFromObjectNode readRealSizeNode, @Cached CastToJavaIntExactNode castToIntNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                Object realSizeObj = readRealSizeNode.execute(cls, StructSequence.T_N_FIELDS);
                if (realSizeObj == PNone.NO_VALUE) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC, PythonUtils.EMPTY_OBJECT_ARRAY);
                }
                int realSize = castToIntNode.execute(inliningTarget, realSizeObj);
                Object[] values = new Object[realSize];
                Arrays.fill(values, PNone.NO_VALUE);
                return factory.createTuple(cls, values);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"attribute 'n_fields' is expected to be a Java int");
            }
        }
    }

    static abstract class PyTruffleStructSequence_NewType
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffleStructSequence_NewType() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(TruffleString typeName, TruffleString typeDoc, Object fields, int nInSequence, @Cached PyTruffleStructSequence_InitType2 initNode, @Cached ReadAttributeFromObjectNode readTypeBuiltinNode, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached CallNode callTypeNewNode, @Cached PythonObjectFactory factory) {
            Object typeBuiltin = readTypeBuiltinNode.execute(this.getCore().getBuiltins(), BuiltinNames.T_TYPE);
            PTuple bases = factory.createTuple(new Object[]{PythonBuiltinClassType.PTuple});
            PDict namespace = factory.createDict(new PKeyword[]{new PKeyword(SpecialAttributeNames.T___DOC__, typeDoc)});
            Object cls = callTypeNewNode.executeWithoutFrame(typeBuiltin, typeName, bases, namespace);
            initNode.execute(cls, fields, nInSequence);
            if (cls instanceof PythonClass) {
                ((PythonClass)cls).makeStaticBase(dylib);
            }
            return cls;
        }
    }

    static abstract class PyTruffleStructSequence_InitType2
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleStructSequence_InitType2() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int doGeneric(Object klass, Object fields, int nInSequence, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CStructAccess.ReadPointerNode readNode, @Cached CExtNodes.FromCharPointerNode fromCharPtr) {
            Object name;
            ArrayList<TruffleString> names = new ArrayList<TruffleString>();
            ArrayList<TruffleString> docs = new ArrayList<TruffleString>();
            int pos = 0;
            while (!((name = readNode.readArrayElement(fields, pos * 2)) instanceof Long && (Long)name == 0L || lib.isNull(name))) {
                Object doc = readNode.readArrayElement(fields, pos * 2 + 1);
                names.add(fromCharPtr.execute(name));
                docs.add(lib.isNull(doc) ? null : fromCharPtr.execute(doc));
                ++pos;
            }
            TruffleString[] fieldNames = (TruffleString[])names.toArray(TruffleString[]::new);
            TruffleString[] fieldDocs = (TruffleString[])docs.toArray(TruffleString[]::new);
            StructSequence.Descriptor d = new StructSequence.Descriptor(null, nInSequence, fieldNames, fieldDocs);
            StructSequence.initType(PythonLanguage.get(readNode), klass, d);
            return 0;
        }
    }
}

