/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictDelItem;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_csv")
public final class CSVModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T__DIALECTS = PythonUtils.tsLiteral("_dialects");
    static final String J_ATTR_DELIMITER = "delimiter";
    private static final TruffleString T_ATTR_DELIMITER = PythonUtils.tsLiteral("delimiter");
    static final String J_ATTR_DOUBLEQUOTE = "doublequote";
    private static final TruffleString T_ATTR_DOUBLEQUOTE = PythonUtils.tsLiteral("doublequote");
    static final String J_ATTR_ESCAPECHAR = "escapechar";
    private static final TruffleString T_ATTR_ESCAPECHAR = PythonUtils.tsLiteral("escapechar");
    static final String J_ATTR_LINETERMINATOR = "lineterminator";
    private static final TruffleString T_ATTR_LINETERMINATOR = PythonUtils.tsLiteral("lineterminator");
    static final String J_ATTR_QUOTING = "quoting";
    private static final TruffleString T_ATTR_QUOTING = PythonUtils.tsLiteral("quoting");
    static final String J_ATTR_QUOTECHAR = "quotechar";
    private static final TruffleString T_ATTR_QUOTECHAR = PythonUtils.tsLiteral("quotechar");
    static final String J_ATTR_SKIPINITIALSPACE = "skipinitialspace";
    private static final TruffleString T_ATTR_SKIPINITIALSPACE = PythonUtils.tsLiteral("skipinitialspace");
    static final String J_ATTR_STRICT = "strict";
    private static final TruffleString T_ATTR_STRICT = StringLiterals.T_STRICT;
    static final String J__CSV = "_csv";
    static final TruffleString T__CSV = PythonUtils.tsLiteral("_csv");
    private static final TruffleString T_NOT_SET = PythonUtils.tsLiteral("NOT_SET");
    static final int NOT_SET_CODEPOINT = -1;
    long fieldLimit = 131072L;
    private static final String CSV_DOC = "CSV parsing and writing.\n\nThis module provides classes that assist in the reading and writing\nof Comma Separated Value (CSV) files, and implements the interface\ndescribed by PEP 305.  Although many CSV files are simple to parse,\nthe format is not formally defined by a stable specification and\nis subtle enough that parsing lines of a CSV file with something\nlike line.split(\",\") is bound to fail.  The module supports three\nbasic APIs: reading, writing, and registration of dialects.\n\n\nDIALECT REGISTRATION:\n\nReaders and writers support a dialect argument, which is a convenient\nhandle on a group of settings.  When the dialect argument is a string,\nit identifies one of the dialects previously registered with the module.\nIf it is a class or instance, the attributes of the argument are used as\nthe settings for the reader or writer:\n\n    class excel:\n        delimiter = ','\n        quotechar = '\"'\n        escapechar = None\n        doublequote = True\n        skipinitialspace = False\n        lineterminator = '\\r\\n'\n        quoting = QUOTE_MINIMAL\n\nSETTINGS:\n\n    * quotechar - specifies a one-character string to use as the\n        quoting character.  It defaults to '\"'.\n    * delimiter - specifies a one-character string to use as the\n        field separator.  It defaults to ','.\n    * skipinitialspace - specifies how to interpret whitespace which\n        immediately follows a delimiter.  It defaults to False, which\n        means that whitespace immediately following a delimiter is part\n        of the following field.\n    * lineterminator -  specifies the character sequence which should\n        terminate rows.\n    * quoting - controls when quotes should be generated by the writer.\n        It can take on any of the following module constants:\n\n        csv.QUOTE_MINIMAL means only when required, for example, when a\n            field contains either the quotechar or the delimiter\n        csv.QUOTE_ALL means that quotes are always placed around fields.\n        csv.QUOTE_NONNUMERIC means that quotes are always placed around\n            fields which do not parse as integers or floating point\n            numbers.\n        csv.QUOTE_NONE means that quotes are never placed around fields.\n    * escapechar - specifies a one-character string used to escape\n        the delimiter when quoting is set to QUOTE_NONE.\n    * doublequote - controls the handling of quotes inside fields.  When\n        True, two consecutive quotes are interpreted as one during read,\n        and when writing, each quote character embedded in the data is\n        written as two quotes\n";
    private static final String READER_DOC = "\ncsv_reader = reader(iterable [, dialect='excel']\n                    [optional keyword args])\nfor row in csv_reader:\nprocess(row)\n\nThe \"iterable\" argument can be any object that returns a line\nof input for each iteration, such as a file object or a list.  The\noptional \"dialect\" parameter is discussed below.  The function\nalso accepts optional keyword arguments which override settings\nprovided by the dialect.\n\nThe returned object is an iterator.  Each iteration returns a row\nof the CSV file (which can span multiple input lines)";
    private static final String WRITER_DOC = "    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    for row in sequence:\n        csv_writer.writerow(row)\n\n    [or]\n\n    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    csv_writer.writerows(rows)\n\nThe \"fileobj\" argument can be any object that supports the file API.\n";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)CSV_DOC);
        this.addBuiltinConstant("__version__", (Object)"1.0");
        this.addBuiltinConstant("QUOTE_MINIMAL", (Object)QuoteStyle.QUOTE_MINIMAL.ordinal());
        this.addBuiltinConstant("QUOTE_ALL", (Object)QuoteStyle.QUOTE_ALL.ordinal());
        this.addBuiltinConstant("QUOTE_NONNUMERIC", (Object)QuoteStyle.QUOTE_NONNUMERIC.ordinal());
        this.addBuiltinConstant("QUOTE_NONE", (Object)QuoteStyle.QUOTE_NONE.ordinal());
        this.addBuiltinConstant(T__DIALECTS, (Object)core.factory().createDict());
        super.initialize(core);
    }

    @Builtin(name="CSVDialect", constructsClass=PythonBuiltinClassType.CSVDialect, parameterNames={"class", "dialect", "delimiter", "doublequote", "escapechar", "lineterminator", "quotechar", "quoting", "skipinitialspace", "strict"})
    @GenerateNodeFactory
    public static abstract class DialectNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doCSVDialectWithoutKeywords(PythonBuiltinClassType cls, CSVDialect dialect, PNone delimiter, PNone doublequote, PNone escapechar, PNone lineterminator, PNone quotechar, PNone quoting, PNone skipinitialspace, PNone strict) {
            return dialect;
        }

        @Specialization
        static CSVDialect doStringWithoutKeywords(VirtualFrame frame, PythonBuiltinClassType cls, TruffleString dialectName, PNone delimiter, PNone doublequote, PNone escapechar, PNone lineterminator, PNone quotechar, PNone quoting, PNone skipinitialspace, PNone strict, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CSVGetDialectNode getDialect) {
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(T__CSV);
            return getDialect.execute(frame, module, dialectName);
        }

        @Specialization
        static Object doNoDialectObj(VirtualFrame frame, PythonBuiltinClassType cls, PNone dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doStringWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, TruffleString dialectName, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CSVGetDialectNode getDialect, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(T__CSV);
            CSVDialect dialectObj = getDialect.execute(frame, module, dialectName);
            if (delimiterObj == PNone.NO_VALUE) {
                delimiterObj = dialectObj.delimiter;
            }
            if (doublequoteObj == PNone.NO_VALUE) {
                doublequoteObj = dialectObj.doubleQuote;
            }
            if (escapecharObj == PNone.NO_VALUE) {
                escapecharObj = dialectObj.escapeChar;
            }
            if (lineterminatorObj == PNone.NO_VALUE) {
                lineterminatorObj = dialectObj.lineTerminator;
            }
            if (quotingObj == PNone.NO_VALUE) {
                quotingObj = dialectObj.quoting;
            }
            if (quotecharObj == PNone.NO_VALUE) {
                quotecharObj = dialectObj.quoteChar;
            }
            if (skipinitialspaceObj == PNone.NO_VALUE) {
                skipinitialspaceObj = dialectObj.skipInitialSpace;
            }
            if (strictObj == PNone.NO_VALUE) {
                strictObj = dialectObj.strict;
            }
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doDialectClassWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, PythonClass dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectLookupAttr getFirstAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getSecondAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getThirdAttributesNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            delimiterObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, delimiterObj, T_ATTR_DELIMITER, getFirstAttributesNode);
            doublequoteObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, doublequoteObj, T_ATTR_DOUBLEQUOTE, getFirstAttributesNode);
            escapecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, escapecharObj, T_ATTR_ESCAPECHAR, getFirstAttributesNode);
            lineterminatorObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, lineterminatorObj, T_ATTR_LINETERMINATOR, getSecondAttributesNode);
            quotecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotecharObj, T_ATTR_QUOTECHAR, getSecondAttributesNode);
            quotingObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotingObj, T_ATTR_QUOTING, getSecondAttributesNode);
            skipinitialspaceObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, skipinitialspaceObj, T_ATTR_SKIPINITIALSPACE, getThirdAttributesNode);
            strictObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, strictObj, T_ATTR_STRICT, getThirdAttributesNode);
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doPStringWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, PString dialectName, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CSVGetDialectNode getDialect, @Cached CastToTruffleStringNode castToStringNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString dialectNameStr = castToStringNode.execute(inliningTarget, dialectName);
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(T__CSV);
            CSVDialect dialectObj = getDialect.execute(frame, module, dialectNameStr);
            if (delimiterObj == PNone.NO_VALUE) {
                delimiterObj = dialectObj.delimiter;
            }
            if (doublequoteObj == PNone.NO_VALUE) {
                doublequoteObj = dialectObj.doubleQuote;
            }
            if (escapecharObj == PNone.NO_VALUE) {
                escapecharObj = dialectObj.escapeChar;
            }
            if (lineterminatorObj == PNone.NO_VALUE) {
                lineterminatorObj = dialectObj.lineTerminator;
            }
            if (quotingObj == PNone.NO_VALUE) {
                quotingObj = dialectObj.quoting;
            }
            if (quotecharObj == PNone.NO_VALUE) {
                quotecharObj = dialectObj.quoteChar;
            }
            if (skipinitialspaceObj == PNone.NO_VALUE) {
                skipinitialspaceObj = dialectObj.skipInitialSpace;
            }
            if (strictObj == PNone.NO_VALUE) {
                strictObj = dialectObj.strict;
            }
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization(guards={"!isCSVDialect(dialectObj)", "!isPythonClass(dialectObj)", "!isString(dialectObj)", "!isPNone(dialectObj)"})
        static Object doGeneric(VirtualFrame frame, PythonBuiltinClassType cls, Object dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectLookupAttr getFirstAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getSecondAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getThirdAttributesNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            delimiterObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, delimiterObj, T_ATTR_DELIMITER, getFirstAttributesNode);
            doublequoteObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, doublequoteObj, T_ATTR_DOUBLEQUOTE, getFirstAttributesNode);
            escapecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, escapecharObj, T_ATTR_ESCAPECHAR, getFirstAttributesNode);
            lineterminatorObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, lineterminatorObj, T_ATTR_LINETERMINATOR, getSecondAttributesNode);
            quotingObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotingObj, T_ATTR_QUOTING, getSecondAttributesNode);
            quotecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotecharObj, T_ATTR_QUOTECHAR, getSecondAttributesNode);
            skipinitialspaceObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, skipinitialspaceObj, T_ATTR_SKIPINITIALSPACE, getThirdAttributesNode);
            strictObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, strictObj, T_ATTR_STRICT, getThirdAttributesNode);
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        protected static boolean isCSVDialect(Object dialect) {
            return dialect instanceof CSVDialect;
        }

        private static Object createCSVDialect(VirtualFrame frame, Node inliningTarget, PythonBuiltinClassType cls, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, PyObjectIsTrueNode isTrueNode, PyLongCheckExactNode pyLongCheckExactNode, PyLongAsIntNode pyLongAsIntNode, PRaiseNode.Lazy raiseNode) {
            TruffleString delimiter = DialectNode.getChar(inliningTarget, T_ATTR_DELIMITER, delimiterObj, StringLiterals.T_COMMA, false);
            boolean doubleQuote = DialectNode.getBoolean(frame, inliningTarget, doublequoteObj, true, isTrueNode);
            TruffleString escapeChar = DialectNode.getChar(inliningTarget, T_ATTR_ESCAPECHAR, escapecharObj, T_NOT_SET, true);
            TruffleString lineTerminator = DialectNode.getString(inliningTarget, T_ATTR_LINETERMINATOR, lineterminatorObj, StringLiterals.T_CRLF);
            TruffleString quoteChar = DialectNode.getChar(inliningTarget, T_ATTR_QUOTECHAR, quotecharObj, StringLiterals.T_DOUBLE_QUOTE, true);
            QuoteStyle quoting = DialectNode.getQuotingValue(frame, inliningTarget, T_ATTR_QUOTING, quotingObj, QuoteStyle.QUOTE_MINIMAL, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
            boolean skipInitialSpace = DialectNode.getBoolean(frame, inliningTarget, skipinitialspaceObj, false, isTrueNode);
            boolean strict = DialectNode.getBoolean(frame, inliningTarget, strictObj, false, isTrueNode);
            if (quotecharObj == PNone.NONE && quotingObj == PNone.NO_VALUE) {
                quoting = QuoteStyle.QUOTE_NONE;
            }
            return DialectNode.createCSVDialect(inliningTarget, cls, delimiter, doubleQuote, escapeChar, lineTerminator, quoteChar, quoting, skipInitialSpace, strict);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object createCSVDialect(Node raisingNode, PythonBuiltinClassType cls, TruffleString delimiter, boolean doubleQuote, TruffleString escapeChar, TruffleString lineTerminator, TruffleString quoteChar, QuoteStyle quoting, boolean skipInitialSpace, boolean strict) {
            if (TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)delimiter, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.DELIMITER_MUST_BE_ONE_CHAR_STRING);
            }
            if (quoting != QuoteStyle.QUOTE_NONE && TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)quoteChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.QUOTECHAR_MUST_BE_SET_IF_QUOTING_ENABLED);
            }
            if (lineTerminator == null) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.LINETERMINATOR_MUST_BE_SET);
            }
            int delimiterCodePoint = TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)delimiter, 0, PythonUtils.TS_ENCODING);
            int escapeCharCodePoint = TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)escapeChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING) ? -1 : TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)escapeChar, 0, PythonUtils.TS_ENCODING);
            int quoteCharCodePoint = TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)quoteChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING) ? -1 : TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)quoteChar, 0, PythonUtils.TS_ENCODING);
            return PythonObjectFactory.getUncached().createCSVDialect((Object)cls, delimiter, delimiterCodePoint, doubleQuote, escapeChar, escapeCharCodePoint, lineTerminator, quoteChar, quoteCharCodePoint, quoting, skipInitialSpace, strict);
        }

        private static Object getAttributeValue(VirtualFrame frame, Node inliningTarget, Object dialect, Object inputValue, TruffleString attributeName, PyObjectLookupAttr getAttributeNode) {
            if (inputValue != PNone.NO_VALUE) {
                return inputValue;
            }
            return getAttributeNode.execute((Frame)frame, inliningTarget, dialect, attributeName);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getChar(Node raisingNode, TruffleString name, Object valueObj, TruffleString defaultValue, boolean optional) {
            TruffleString charValue;
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (optional && valueObj == PNone.NONE) {
                return T_NOT_SET;
            }
            try {
                charValue = CastToTruffleStringNode.executeUncached(valueObj);
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, optional ? ErrorMessages.S_MUST_BE_STRING_OR_NONE_NOT_S : ErrorMessages.S_MUST_BE_STRING_NOT_S, name, GetClassNode.executeUncached(valueObj));
            }
            if (optional && TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)charValue, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                return T_NOT_SET;
            }
            if (TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)charValue, PythonUtils.TS_ENCODING) != 1) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.MUST_BE_ONE_CHARACTER_STRING, name);
            }
            return charValue;
        }

        private static boolean getBoolean(VirtualFrame frame, Node inliningTarget, Object valueObj, boolean defaultValue, PyObjectIsTrueNode isTrueNode) {
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            return isTrueNode.execute((Frame)frame, inliningTarget, valueObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getString(Node raisingNode, TruffleString attribute, Object valueObj, TruffleString defaultValue) {
            TruffleString value;
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (valueObj == PNone.NONE) {
                return null;
            }
            try {
                value = CastToTruffleStringNode.executeUncached(valueObj);
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRING_QUOTED, attribute);
            }
            return value;
        }

        private static QuoteStyle getQuotingValue(VirtualFrame frame, Node inliningTarget, TruffleString name, Object valueObj, QuoteStyle defaultValue, PyLongCheckExactNode pyLongCheckExactNode, PyLongAsIntNode pyLongAsIntNode, PRaiseNode.Lazy raiseNode) {
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (valueObj instanceof QuoteStyle) {
                return (QuoteStyle)((Object)valueObj);
            }
            if (!pyLongCheckExactNode.execute(inliningTarget, valueObj)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_INTEGER_QUOTED_ATTR, name);
            }
            int value = pyLongAsIntNode.execute((Frame)frame, inliningTarget, valueObj);
            if (!QuoteStyle.containsOrdinalValue(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BAD_QUOTING_VALUE);
            }
            return QuoteStyle.getQuoteStyle(value);
        }
    }

    @Builtin(name="field_size_limit", parameterNames={"$mod", "limit"}, declaresExplicitSelf=true, doc="Sets an upper limit on parsed fields.\ncsv.field_size_limit([limit])\n\nReturns old limit. If limit is not given, no new limit is set and\nthe old limit is returned")
    @GenerateNodeFactory
    public static abstract class CSVFieldSizeLimitNode
    extends PythonBuiltinNode {
        @Specialization
        static long getOrSetFieldSizeLimit(VirtualFrame frame, PythonModule self, Object newLimit, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckExactNode checkLongNode, @Cached PyLongAsLongNode castToLong, @Cached PRaiseNode.Lazy raiseNode) {
            CSVModuleBuiltins csvModuleBuiltins = (CSVModuleBuiltins)self.getBuiltins();
            long oldLimit = csvModuleBuiltins.fieldLimit;
            if (newLimit != PNone.NO_VALUE) {
                if (!checkLongNode.execute(inliningTarget, newLimit)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_INTEGER, "limit");
                }
                csvModuleBuiltins.fieldLimit = castToLong.execute((Frame)frame, inliningTarget, newLimit);
            }
            return oldLimit;
        }
    }

    @Builtin(name="writer", doc="    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    for row in sequence:\n        csv_writer.writerow(row)\n\n    [or]\n\n    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    csv_writer.writerows(rows)\n\nThe \"fileobj\" argument can be any object that supports the file API.\n", parameterNames={"outputfile", "dialect"}, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CSVWriterNode
    extends PythonBuiltinNode {
        @Specialization
        static Object createReader(VirtualFrame frame, Object outputFile, Object dialectObj, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectLookupAttr lookupAttr, @Cached PyCallableCheckNode checkCallable, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object write = lookupAttr.execute((Frame)frame, inliningTarget, outputFile, IONodes.T_WRITE);
            if (write == PNone.NO_VALUE || !checkCallable.execute(inliningTarget, write)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_HAVE_WRITE_METHOD, "argument 1");
            }
            CSVDialect dialect = (CSVDialect)callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, kwargs);
            return factory.createCSVWriter((Object)PythonBuiltinClassType.CSVWriter, write, dialect);
        }
    }

    @Builtin(name="reader", doc="\ncsv_reader = reader(iterable [, dialect='excel']\n                    [optional keyword args])\nfor row in csv_reader:\nprocess(row)\n\nThe \"iterable\" argument can be any object that returns a line\nof input for each iteration, such as a file object or a list.  The\noptional \"dialect\" parameter is discussed below.  The function\nalso accepts optional keyword arguments which override settings\nprovided by the dialect.\n\nThe returned object is an iterator.  Each iteration returns a row\nof the CSV file (which can span multiple input lines)", parameterNames={"csvfile", "dialect"}, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CSVReaderNode
    extends PythonBuiltinNode {
        @Specialization
        static Object createReader(VirtualFrame frame, Object csvfile, Object dialectObj, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached CallNode callNode, @Cached PythonObjectFactory factory) {
            Object inputIter = getIter.execute((Frame)frame, inliningTarget, csvfile);
            CSVDialect dialect = (CSVDialect)callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, kwargs);
            return factory.createCSVReader((Object)PythonBuiltinClassType.CSVReader, inputIter, dialect);
        }
    }

    @Builtin(name="list_dialects", parameterNames={"$mod"}, declaresExplicitSelf=true, doc="Return a list of all known dialect names.\nnames = csv.list_dialects()")
    @GenerateNodeFactory
    public static abstract class CSVListDialectsNode
    extends PythonBuiltinNode {
        @Specialization
        PList listDialects(VirtualFrame frame, PythonModule module, @Cached ReadAttributeFromObjectNode readNode, @Cached ListNodes.ConstructListNode constructListNode) {
            Object dialects = readNode.execute(module, T__DIALECTS);
            return constructListNode.execute((Frame)frame, dialects);
        }
    }

    @Builtin(name="get_dialect", parameterNames={"$mod", "name"}, minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="Return the dialect instance associated with name.\ndialect = csv.get_dialect(name)")
    @GenerateNodeFactory
    public static abstract class CSVGetDialectNode
    extends PythonBuiltinNode {
        public abstract CSVDialect execute(VirtualFrame var1, PythonModule var2, Object var3);

        @NeverDefault
        protected static CSVGetDialectNode create() {
            return CSVModuleBuiltinsFactory.CSVGetDialectNodeFactory.create(null);
        }

        @Specialization
        static CSVDialect get(VirtualFrame frame, PythonModule module, Object nameObj, @Bind(value="this") Node inliningTarget, @Cached PyDictGetItem getItemNode, @Cached ReadAttributeFromObjectNode readNode, @Cached PRaiseNode.Lazy raiseNode) {
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            CSVDialect dialect = (CSVDialect)getItemNode.execute((Frame)frame, inliningTarget, dialects, nameObj);
            if (dialect == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.UNKNOWN_DIALECT);
            }
            return dialect;
        }
    }

    @Builtin(name="unregister_dialect", parameterNames={"$mod", "name"}, minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="Delete the name/dialect mapping associated with a string name.\ncsv.unregister_dialect(name)")
    @GenerateNodeFactory
    public static abstract class CSVUnregisterDialectNode
    extends PythonBuiltinNode {
        @Specialization
        static PNone unregister(VirtualFrame frame, PythonModule module, Object nameObj, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromObjectNode readNode, @Cached PyDictDelItem delItem, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode.Lazy raiseNode) {
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            if (!getItem.hasKey((Frame)frame, inliningTarget, dialects.getDictStorage(), nameObj)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.UNKNOWN_DIALECT);
            }
            delItem.execute((Frame)frame, inliningTarget, dialects, nameObj);
            return PNone.NONE;
        }
    }

    @Builtin(name="register_dialect", parameterNames={"$mod", "name", "dialect"}, minNumOfPositionalArgs=2, takesVarKeywordArgs=true, declaresExplicitSelf=true, doc="Create a mapping from a string name to a dialect class.\ndialect = csv.register_dialect(name, dialect)")
    @GenerateNodeFactory
    public static abstract class CSVRegisterDialectNode
    extends PythonBuiltinNode {
        @Specialization
        static PNone register(VirtualFrame frame, PythonModule module, Object nameObj, Object dialectObj, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode nameNode, @Cached ReadAttributeFromObjectNode readNode, @Cached CallNode callNode, @Cached PyDictSetItem setItem, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString name;
            try {
                name = nameNode.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STRING, "dialect name");
            }
            Object result = callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, keywords);
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            setItem.execute((Frame)frame, inliningTarget, dialects, name, result);
            return PNone.NONE;
        }
    }
}

