/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public final class PBytesIO
extends PythonBuiltinObject {
    private PByteArray buf;
    private int pos;
    private int stringSize;
    private boolean escaped;
    private final BufferLifecycleManager exports = new BufferLifecycleManager();

    public PBytesIO(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public boolean hasBuf() {
        return this.buf != null;
    }

    public PByteArray getBuf() {
        return this.buf;
    }

    public void setBuf(PByteArray buf) {
        this.buf = buf;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void incPos(int n) {
        this.pos += n;
    }

    public int getStringSize() {
        return this.stringSize;
    }

    public void setStringSize(int size) {
        this.stringSize = size;
    }

    public int getExports() {
        return this.exports.getExports().get();
    }

    public void checkExports(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
        if (this.getExports() != 0) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.BufferError, ErrorMessages.EXISTING_EXPORTS_OF_DATA_OBJECT_CANNOT_BE_RE_SIZED);
        }
    }

    public void markEscaped() {
        this.escaped = true;
    }

    public void unshareIfNecessary(PythonBufferAccessLibrary bufferLib, PythonObjectFactory factory) {
        if (this.escaped || this.getExports() != 0) {
            this.buf = factory.createByteArray(bufferLib.getCopiedByteArray(this.buf));
            this.escaped = false;
        }
    }

    public void unshareAndResize(PythonBufferAccessLibrary bufferLib, PythonObjectFactory factory, int size, boolean truncate) {
        int alloc;
        int origLength = bufferLib.getBufferLength(this.getBuf());
        if (truncate && size < origLength / 2) {
            alloc = size;
        } else {
            if (size < origLength) {
                this.unshareIfNecessary(bufferLib, factory);
                return;
            }
            if ((double)size <= (double)origLength * 1.125) {
                alloc = size + (size >> 3) + (size < 9 ? 3 : 6);
                if (alloc < size) {
                    alloc = size;
                }
            } else {
                alloc = size;
            }
        }
        byte[] newBuf = new byte[alloc];
        bufferLib.readIntoByteArray(this.getBuf(), 0, newBuf, 0, Math.min(this.stringSize, size));
        this.setBuf(factory.createByteArray(newBuf));
        this.escaped = false;
    }
}

