/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.pickle.MemoTable;
import com.oracle.graal.python.builtins.modules.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.pickle.PicklerMemoProxyBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.LinkedHashMap;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PicklerMemoProxy})
public class PicklerMemoProxyBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PicklerMemoProxyBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    public static PDict picklerMemoCopyImpl(PythonContext context, MemoTable memoTable) {
        PythonObjectSlowPathFactory factory = context.factory();
        LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
        MemoTable.MemoIterator iterator = memoTable.iterator();
        while (iterator.advance()) {
            copy.put(System.identityHashCode(iterator.key()), factory.createTuple(new Object[]{iterator.value(), iterator.key()}));
        }
        return factory.createDictFromMapGeneric(copy);
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PPicklerMemoProxy self, @Cached PythonObjectFactory factory) {
            MemoTable memoTable = self.getPickler().getMemo();
            PDict dictMemoCopy = PicklerMemoProxyBuiltins.picklerMemoCopyImpl(this.getContext(), memoTable);
            PTuple dictArgs = factory.createTuple(new Object[]{dictMemoCopy});
            return factory.createTuple(new Object[]{PythonBuiltinClassType.PDict, dictArgs});
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(PPicklerMemoProxy self) {
            MemoTable memoTable = self.getPickler().getMemo();
            return PicklerMemoProxyBuiltins.picklerMemoCopyImpl(this.getContext(), memoTable);
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clear(PPicklerMemoProxy self) {
            MemoTable memoTable = self.getPickler().getMemo();
            memoTable.clear();
            return PNone.NONE;
        }
    }
}

