/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapperFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativePrimitiveSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.logging.Level;

public final class PySequenceArrayWrapper {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PySequenceArrayWrapper.class);

    @CompilerDirectives.TruffleBoundary
    public static Object ensureNativeSequence(PSequence sequence) {
        MroSequenceStorage mro;
        Object result;
        SequenceStorage sequenceStorage;
        boolean loggable = LOGGER.isLoggable(Level.FINE);
        if (loggable) {
            LOGGER.fine(String.format("ensureNativeSequence(%s)", sequence));
        }
        if ((sequenceStorage = sequence.getSequenceStorage()) instanceof NativeSequenceStorage) {
            NativeSequenceStorage nativeStorage = (NativeSequenceStorage)sequenceStorage;
            result = nativeStorage.getPtr();
        } else if (sequenceStorage instanceof MroSequenceStorage && (mro = (MroSequenceStorage)sequenceStorage).isNative()) {
            result = mro.getNativeMirror().getPtr();
        } else {
            NativeSequenceStorage nativeStorage = ToNativeStorageNode.executeUncached(sequenceStorage, sequence instanceof PBytesLike);
            if (!(sequenceStorage instanceof MroSequenceStorage)) {
                sequence.setSequenceStorage(nativeStorage);
            }
            result = nativeStorage.getPtr();
        }
        if (loggable) {
            LOGGER.fine(String.format("ensureNativeSequence(%s) = %s", sequence, PythonUtils.formatPointer(result)));
        }
        return result;
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class ToNativeStorageNode
    extends Node {
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(ToNativeStorageNode.class);

        public abstract NativeSequenceStorage execute(Node var1, SequenceStorage var2, boolean var3);

        public static NativeSequenceStorage executeUncached(SequenceStorage object, boolean isBytesLike) {
            return PySequenceArrayWrapperFactory.ToNativeStorageNodeGen.getUncached().execute(null, object, isBytesLike);
        }

        @Specialization(guards={"!isMroSequenceStorage(s)"})
        static NativeSequenceStorage doManaged(Node inliningTarget, ArrayBasedSequenceStorage s, boolean isBytesLike, @Cached.Exclusive @Cached SequenceStorageNodes.StorageToNativeNode storageToNativeNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalArrayNode) {
            Object[] array;
            if (isBytesLike) {
                ByteSequenceStorage byteStorage = (ByteSequenceStorage)s;
                array = byteStorage.getInternalByteArray();
            } else {
                array = getInternalArrayNode.execute(inliningTarget, s);
            }
            return storageToNativeNode.execute(inliningTarget, array, s.length());
        }

        @Specialization
        static NativeSequenceStorage doNativePrimitive(Node inliningTarget, NativePrimitiveSequenceStorage s, boolean isBytesLike, @Cached.Exclusive @Cached SequenceStorageNodes.StorageToNativeNode storageToNativeNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalArrayNode) {
            Object[] array = getInternalArrayNode.execute(inliningTarget, s);
            return storageToNativeNode.execute(inliningTarget, array, s.length());
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static NativeSequenceStorage doMroSequenceStorage(Node inliningTarget, MroSequenceStorage mro, boolean isBytesLike) {
            if (mro.getNativeMirror() != null) {
                return mro.getNativeMirror();
            }
            assert (!isBytesLike);
            PythonAbstractClass[] internalClassArray = mro.getInternalClassArray();
            assert (mro.length() <= internalClassArray.length);
            NativeSequenceStorage ns = SequenceStorageNodesFactory.StorageToNativeNodeGen.getUncached().execute(inliningTarget, internalClassArray, mro.length());
            mro.setNativeMirror(ns);
            return ns;
        }

        @Specialization
        static NativeSequenceStorage doNative(NativeSequenceStorage s, boolean isBytesLike) {
            return s;
        }

        @Specialization
        static NativeSequenceStorage doEmptyStorage(Node inliningTarget, EmptySequenceStorage s, boolean isBytesLike, @Cached.Exclusive @Cached SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            return storageToNativeNode.execute(inliningTarget, isBytesLike ? PythonUtils.EMPTY_BYTE_ARRAY : (byte[])PythonUtils.EMPTY_OBJECT_ARRAY, 0);
        }

        static boolean isNative(SequenceStorage s) {
            return s instanceof NativeSequenceStorage;
        }

        static boolean isEmptySequenceStorage(SequenceStorage s) {
            return s instanceof EmptySequenceStorage;
        }

        static boolean isMroSequenceStorage(SequenceStorage s) {
            return s instanceof MroSequenceStorage;
        }
    }
}

