/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.PyBoolCheckNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class TpSlotInquiry {
    private TpSlotInquiry() {
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CallNbBoolPythonNode
    extends Node {
        abstract boolean execute(VirtualFrame var1, TpSlot.TpSlotPythonSingle var2, Object var3);

        @Specialization
        static boolean doIt(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Bind(value="this") Node inliningTarget, @Cached PythonDispatchers.UnaryPythonSlotDispatcherNode dispatcherNode, @Cached PyBoolCheckNode pyBoolCheckNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PyObjectIsTrueNode pyObjectIsTrueNode) {
            Object result = dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self);
            if (!pyBoolCheckNode.execute(inliningTarget, result)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.BOOL_SHOULD_RETURN_BOOL, result);
            }
            return pyObjectIsTrueNode.execute((Frame)frame, inliningTarget, result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotNbBoolNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "nb_bool");

        public abstract boolean execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"slot == cachedSlot"}, limit="3")
        static boolean callCachedBuiltin(VirtualFrame frame, TpSlotInquiryBuiltin slot, Object self, @Cached(value="slot") TpSlotInquiryBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") InquiryBuiltinNode slotNode) {
            return slotNode.executeBool(frame, self);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        static boolean callGenericSimpleBuiltin(TpSlotInquiryBuiltin slot, Object self) {
            return slot.executeUncached(self);
        }

        @Specialization
        static boolean callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) CallNbBoolPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static boolean callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotNative slot, Object self, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) ExternalFunctionNodes.CheckInquiryResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___BOOL__, slot.callable, toNativeNode.execute(self));
            return checkResultNode.executeBool(threadState, SpecialMethodNames.T___BOOL__, result);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class NbBoolBuiltinNode
    extends InquiryBuiltinNode {
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class InquiryBuiltinNode
    extends PythonUnaryBuiltinNode {
        public abstract boolean executeBool(VirtualFrame var1, Object var2);

        @Override
        public final Object execute(VirtualFrame frame, Object arg) {
            return this.executeBool(frame, arg);
        }
    }

    public static abstract class TpSlotInquiryBuiltin<T extends InquiryBuiltinNode>
    extends TpSlot.TpSlotSimpleBuiltinBase<T> {
        protected TpSlotInquiryBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, BuiltinSlotWrapperSignature.UNARY, ExternalFunctionNodes.PExternalFunctionWrapper.INQUIRY);
        }

        final InquiryBuiltinNode createSlotNode() {
            return (InquiryBuiltinNode)((Object)this.createNode());
        }

        protected abstract boolean executeUncached(Object var1);
    }
}

