/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.release_callback;

import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.arrow.ArrowSchema;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import sun.misc.Unsafe;

@GenerateCached(value=false)
@GenerateInline
@GenerateUncached
public abstract class ArrowSchemaReleaseCallbackNode
extends Node {
    public abstract void execute(Node var1, ArrowSchema var2);

    @Specialization
    static void release(Node inliningTarget, ArrowSchema arrowSchema, @Cached PRaiseNode.Lazy raiseNode) {
        if (arrowSchema.isReleased()) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARROW_SCHEMA_ALREADY_RELEASED);
        }
        Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
        unsafe.freeMemory(arrowSchema.getFormat());
        arrowSchema.markRelease();
    }
}

