/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
public abstract class LookupAndCallUnaryNode
extends Node {
    protected final TruffleString name;
    private final SpecialMethodSlot slot;
    protected final Supplier<NoAttributeHandler> handlerFactory;
    @Node.Child
    private NoAttributeHandler handler;

    public abstract Object executeObject(VirtualFrame var1, Object var2);

    @NeverDefault
    public static LookupAndCallUnaryNode create(TruffleString name) {
        return LookupAndCallUnaryNodeGen.create(name, null);
    }

    @NeverDefault
    public static LookupAndCallUnaryNode create(SpecialMethodSlot slot) {
        return LookupAndCallUnaryNodeGen.create(slot, null);
    }

    @NeverDefault
    public static LookupAndCallUnaryNode create(TruffleString name, Supplier<NoAttributeHandler> handlerFactory) {
        return LookupAndCallUnaryNodeGen.create(name, handlerFactory);
    }

    @NeverDefault
    public static LookupAndCallUnaryNode create(SpecialMethodSlot slot, Supplier<NoAttributeHandler> handlerFactory) {
        return LookupAndCallUnaryNodeGen.create(slot, handlerFactory);
    }

    LookupAndCallUnaryNode(SpecialMethodSlot slot, Supplier<NoAttributeHandler> handlerFactory) {
        this.slot = slot;
        this.name = slot.getName();
        this.handlerFactory = handlerFactory;
    }

    LookupAndCallUnaryNode(TruffleString name, Supplier<NoAttributeHandler> handlerFactory) {
        this.slot = null;
        this.name = name;
        this.handlerFactory = handlerFactory;
    }

    public TruffleString getMethodName() {
        return this.name;
    }

    protected final PythonUnaryBuiltinNode getUnaryBuiltin(PythonBuiltinClassType clazz) {
        PBuiltinFunction builtinFunction;
        if (this.slot != null) {
            Object attribute = this.slot.getValue(clazz);
            if (attribute instanceof BuiltinMethodDescriptor.UnaryBuiltinDescriptor) {
                return ((BuiltinMethodDescriptor.UnaryBuiltinDescriptor)attribute).createNode();
            }
            return null;
        }
        Object attribute = LookupAttributeInMRONode.Dynamic.getUncached().execute((Object)clazz, this.name);
        if (attribute instanceof PBuiltinFunction && PythonUnaryBuiltinNode.class.isAssignableFrom((builtinFunction = (PBuiltinFunction)attribute).getBuiltinNodeFactory().getNodeClass())) {
            return (PythonUnaryBuiltinNode)((Object)builtinFunction.getBuiltinNodeFactory().createNode(new Object[0]));
        }
        return null;
    }

    protected static PythonBuiltinClassType getBuiltinClass(Node inliningTarget, Object receiver, GetClassNode getClassNode) {
        Object clazz = getClassNode.execute(inliningTarget, receiver);
        return clazz instanceof PythonBuiltinClassType ? (PythonBuiltinClassType)((Object)clazz) : null;
    }

    protected static boolean isClazz(Node inliningTarget, PythonBuiltinClassType clazz, Object receiver, GetClassNode getClassNode) {
        return getClassNode.execute(inliningTarget, receiver) == clazz;
    }

    @Specialization(guards={"clazz != null", "function != null", "isClazz(inliningTarget, clazz, receiver, getClassNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObjectBuiltin(VirtualFrame frame, Object receiver, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached(value="getBuiltinClass(this, receiver, getClassNode)") PythonBuiltinClassType clazz, @Cached(value="getUnaryBuiltin(clazz)") PythonUnaryBuiltinNode function) {
        return function.execute(frame, receiver);
    }

    @Specialization(guards={"getObjectClass(receiver) == cachedClass"}, limit="3")
    Object callObjectGeneric(VirtualFrame frame, Object receiver, @Bind(value="this") Node inliningTarget, @Cached(value="receiver.getClass()") Class<?> cachedClass, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Shared @Cached CallUnaryMethodNode dispatchNode) {
        return this.doCallObject(frame, inliningTarget, receiver, getClassNode, getattr, dispatchNode);
    }

    @Specialization(replaces={"callObjectGeneric"})
    @ReportPolymorphism.Megamorphic
    Object callObjectMegamorphic(VirtualFrame frame, Object receiver, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Shared @Cached CallUnaryMethodNode dispatchNode) {
        return this.doCallObject(frame, inliningTarget, receiver, getClassNode, getattr, dispatchNode);
    }

    protected Class<?> getObjectClass(Object object) {
        return object.getClass();
    }

    private Object doCallObject(VirtualFrame frame, Node inliningTarget, Object receiver, GetClassNode getClassNode, LookupSpecialBaseNode getattr, CallUnaryMethodNode dispatchNode) {
        Object attr = getattr.execute((Frame)frame, getClassNode.execute(inliningTarget, receiver), receiver);
        if (attr == PNone.NO_VALUE) {
            if (this.handlerFactory != null) {
                if (this.handler == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.handler = (NoAttributeHandler)this.insert((NoAttributeHandler)((Object)this.handlerFactory.get()));
                }
                return this.handler.execute(receiver);
            }
            return PNone.NO_VALUE;
        }
        return dispatchNode.executeObject((Frame)frame, attr, receiver);
    }

    @NeverDefault
    protected final LookupSpecialBaseNode createLookup() {
        if (this.slot != null) {
            return LookupSpecialMethodSlotNode.create(this.slot);
        }
        return LookupSpecialMethodNode.create(this.name);
    }

    public static abstract class NoAttributeHandler
    extends PNodeWithContext {
        public abstract Object execute(Object var1);
    }

    @GenerateUncached
    public static abstract class LookupAndCallUnaryDynamicNode
    extends PNodeWithContext {
        public abstract Object executeObject(Object var1, TruffleString var2);

        @Specialization
        static Object doObject(Object receiver, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic getattr, @Cached CallUnaryMethodNode dispatchNode, @Cached InlinedConditionProfile profile) {
            Object attr = getattr.execute(null, inliningTarget, getClassNode.execute(inliningTarget, receiver), name, receiver);
            if (profile.profile(inliningTarget, attr != PNone.NO_VALUE)) {
                return dispatchNode.executeObject(null, attr, receiver);
            }
            return PNone.NO_VALUE;
        }

        public static LookupAndCallUnaryDynamicNode getUncached() {
            return LookupAndCallUnaryNodeGen.LookupAndCallUnaryDynamicNodeGen.getUncached();
        }
    }
}

