/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Objects;

public final class ReadCallerFrameNode
extends Node {
    @CompilerDirectives.CompilationFinal
    private ConditionProfile cachedCallerFrameProfile;
    @Node.Child
    private MaterializeFrameNode materializeNode;

    protected ReadCallerFrameNode() {
    }

    @NeverDefault
    public static ReadCallerFrameNode create() {
        return new ReadCallerFrameNode();
    }

    public PFrame executeWith(VirtualFrame frame, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo((Frame)frame), FrameSelector.SKIP_PYTHON_INTERNAL, level);
    }

    public PFrame executeWith(VirtualFrame frame, FrameSelector selector, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo((Frame)frame), selector, level);
    }

    public PFrame executeWith(Frame startFrame, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo(startFrame), FrameSelector.SKIP_PYTHON_INTERNAL, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, int level) {
        return this.executeWith(startFrameInfo, FrameSelector.SKIP_PYTHON_INTERNAL, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, int level) {
        return this.executeWith(startFrameInfo, frameAccess, FrameSelector.SKIP_PYTHON_INTERNAL, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameSelector selector, int level) {
        return this.executeWith(startFrameInfo, FrameInstance.FrameAccess.READ_ONLY, selector, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        PFrame.Reference curFrameInfo = startFrameInfo;
        if (this.cachedCallerFrameProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedCallerFrameProfile = ConditionProfile.create();
            int i = 0;
            while (i <= level) {
                PFrame.Reference callerInfo = curFrameInfo.getCallerInfo();
                if (callerInfo == null) {
                    Frame callerFrame = ReadCallerFrameNode.getCallerFrame(startFrameInfo, frameAccess, selector, level);
                    if (callerFrame != null) {
                        return this.ensureMaterializeNode().execute(false, true, callerFrame);
                    }
                    return null;
                }
                if (!selector.skip(callerInfo)) {
                    ++i;
                }
                curFrameInfo = callerInfo;
            }
        } else {
            curFrameInfo = this.walkLevels(curFrameInfo, frameAccess, selector, level);
        }
        return curFrameInfo.getPyFrame();
    }

    private PFrame.Reference walkLevels(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        PFrame.Reference currentFrame = startFrameInfo;
        int i = 0;
        while (i <= level) {
            PFrame.Reference callerInfo = currentFrame.getCallerInfo();
            if (this.cachedCallerFrameProfile.profile(callerInfo == null || callerInfo.getPyFrame() == null)) {
                Frame callerFrame = ReadCallerFrameNode.getCallerFrame(startFrameInfo, frameAccess, selector, level);
                if (callerFrame != null) {
                    this.ensureMaterializeNode().execute(false, true, callerFrame);
                    return PArguments.getCurrentFrameInfo(callerFrame);
                }
                return PFrame.Reference.EMPTY;
            }
            if (!selector.skip(callerInfo)) {
                ++i;
            }
            currentFrame = callerInfo;
        }
        return currentFrame;
    }

    public static Frame getCurrentFrame(Node requestingNode, FrameInstance.FrameAccess frameAccess) {
        return ReadCallerFrameNode.getFrame(Objects.requireNonNull(requestingNode), null, frameAccess, FrameSelector.ALL_PYTHON_FRAMES, 0);
    }

    public static Frame getCallerFrame(PFrame.Reference startFrame, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return ReadCallerFrameNode.getFrame(null, Objects.requireNonNull(startFrame), frameAccess, selector, level);
    }

    @CompilerDirectives.TruffleBoundary
    private static Frame getFrame(final Node requestingNode, final PFrame.Reference startFrame, final FrameInstance.FrameAccess frameAccess, final FrameSelector selector, final int level) {
        final Frame[] outputFrame = new Frame[1];
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Frame>(){
            int i = -1;

            public Frame visitFrame(FrameInstance frameInstance) {
                PRootNode pRootNode;
                RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
                RootNode rootNode = target.getRootNode();
                Node callNode = frameInstance.getCallNode();
                boolean didMark = IndirectCallData.setEncapsulatingNeedsToPassCallerFrame(callNode != null ? callNode : requestingNode);
                if (outputFrame[0] == null && rootNode instanceof PRootNode && (pRootNode = (PRootNode)rootNode).setsUpCalleeContext()) {
                    pRootNode.setNeedsCallerFrame();
                    if (this.i < 0 && startFrame != null) {
                        Frame roFrame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                        if (PArguments.getCurrentFrameInfo(roFrame) == startFrame) {
                            this.i = 0;
                        }
                    } else if (!selector.skip(pRootNode)) {
                        if (this.i == level || startFrame == null) {
                            Frame frame = frameInstance.getFrame(frameAccess);
                            assert (PArguments.isPythonFrame(frame));
                            PFrame.Reference info = PArguments.getCurrentFrameInfo(frame);
                            if (callNode != null) {
                                info.setCallNode(callNode);
                            } else {
                                info.setCallNode((Node)pRootNode);
                            }
                            assert (info.getCallNode() != null) : "tried to read frame without location (root: " + String.valueOf((Object)pRootNode) + ")";
                            outputFrame[0] = frame;
                        }
                        ++this.i;
                    }
                }
                if (didMark) {
                    return outputFrame[0];
                }
                return null;
            }
        });
        return outputFrame[0];
    }

    private MaterializeFrameNode ensureMaterializeNode() {
        if (this.materializeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.materializeNode = (MaterializeFrameNode)this.insert(MaterializeFrameNodeGen.create());
        }
        return this.materializeNode;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FrameSelector {
        ALL_PYTHON_FRAMES{

            @Override
            public boolean skip(RootNode rootNode) {
                return false;
            }
        }
        ,
        SKIP_PYTHON_INTERNAL{

            @Override
            public boolean skip(RootNode rootNode) {
                return PRootNode.isPythonInternal(rootNode);
            }
        }
        ,
        SKIP_INTERNAL{

            @Override
            public boolean skip(RootNode rootNode) {
                return rootNode != null && rootNode.isInternal() || PRootNode.isPythonInternal(rootNode);
            }
        }
        ,
        SKIP_PYTHON_BUILTIN{

            @Override
            public boolean skip(RootNode rootNode) {
                return PRootNode.isPythonBuiltin(rootNode);
            }
        };


        public abstract boolean skip(RootNode var1);

        public final boolean skip(PFrame.Reference ref) {
            Node callNode = ref.getCallNode();
            return callNode == null || this.skip(callNode.getRootNode());
        }
    }
}

