/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.nodes.InteropMethodNames;
import com.oracle.truffle.api.strings.TruffleString;

public enum InteropBehaviorMethod {
    is_boolean("is_boolean", InteropMethodNames.T_IS_BOOLEAN),
    is_date("is_date", InteropMethodNames.T_IS_DATE),
    is_duration("is_duration", InteropMethodNames.T_IS_DURATION),
    is_iterator("is_iterator", InteropMethodNames.T_IS_ITERATOR),
    is_number("is_number", InteropMethodNames.T_IS_NUMBER),
    is_string("is_string", InteropMethodNames.T_IS_STRING),
    is_time("is_time", InteropMethodNames.T_IS_TIME),
    is_time_zone("is_time_zone", InteropMethodNames.T_IS_TIME_ZONE),
    is_executable("is_executable", InteropMethodNames.T_IS_EXECUTABLE),
    fits_in_big_integer("fits_in_big_integer", InteropMethodNames.T_FITS_IN_BIG_INTEGER),
    fits_in_byte("fits_in_byte", InteropMethodNames.T_FITS_IN_BYTE),
    fits_in_double("fits_in_double", InteropMethodNames.T_FITS_IN_DOUBLE),
    fits_in_float("fits_in_float", InteropMethodNames.T_FITS_IN_FLOAT),
    fits_in_int("fits_in_int", InteropMethodNames.T_FITS_IN_INT),
    fits_in_long("fits_in_long", InteropMethodNames.T_FITS_IN_LONG),
    fits_in_short("fits_in_short", InteropMethodNames.T_FITS_IN_SHORT),
    as_big_integer("as_big_integer", InteropMethodNames.T_AS_BIG_INTEGER),
    as_boolean("as_boolean", InteropMethodNames.T_AS_BOOLEAN),
    as_byte("as_byte", InteropMethodNames.T_AS_BYTE),
    as_date("as_date", InteropMethodNames.T_AS_DATE),
    as_double("as_double", InteropMethodNames.T_AS_DOUBLE),
    as_duration("as_duration", InteropMethodNames.T_AS_DURATION),
    as_float("as_float", InteropMethodNames.T_AS_FLOAT),
    as_int("as_int", InteropMethodNames.T_AS_INT),
    as_long("as_long", InteropMethodNames.T_AS_LONG),
    as_short("as_short", InteropMethodNames.T_AS_SHORT),
    as_string("as_string", InteropMethodNames.T_AS_STRING),
    as_time("as_time", InteropMethodNames.T_AS_TIME),
    as_time_zone("as_time_zone", InteropMethodNames.T_AS_TIME_ZONE),
    execute("execute", InteropMethodNames.T_EXECUTE, 0, true),
    read_array_element("read_array_element", InteropMethodNames.T_READ_ARRAY_ELEMENT, 1),
    get_array_size("get_array_size", InteropMethodNames.T_GET_ARRAY_SIZE),
    has_array_elements("has_array_elements", InteropMethodNames.T_HAS_ARRAY_ELEMENTS),
    is_array_element_readable("is_array_element_readable", InteropMethodNames.T_IS_ARRAY_ELEMENT_READABLE, 1),
    is_array_element_modifiable("is_array_element_modifiable", InteropMethodNames.T_IS_ARRAY_ELEMENT_MODIFIABLE, 1),
    is_array_element_insertable("is_array_element_insertable", InteropMethodNames.T_IS_ARRAY_ELEMENT_INSERTABLE, 1),
    is_array_element_removable("is_array_element_removable", InteropMethodNames.T_IS_ARRAY_ELEMENT_REMOVABLE, 1),
    remove_array_element("remove_array_element", InteropMethodNames.T_REMOVE_ARRAY_ELEMENT, 1),
    write_array_element("write_array_element", InteropMethodNames.T_WRITE_ARRAY_ELEMENT, 2),
    has_iterator("has_iterator", InteropMethodNames.T_HAS_ITERATOR),
    has_iterator_next_element("has_iterator_next_element", InteropMethodNames.T_HAS_ITERATOR_NEXT_ELEMENT),
    get_iterator("get_iterator", InteropMethodNames.T_GET_ITERATOR),
    get_iterator_next_element("get_iterator_next_element", InteropMethodNames.T_GET_ITERATOR_NEXT_ELEMENT),
    has_hash_entries("has_hash_entries", InteropMethodNames.T_HAS_HASH_ENTRIES),
    get_hash_entries_iterator("get_hash_entries_iterator", InteropMethodNames.T_GET_HASH_ENTRIES_ITERATOR),
    get_hash_keys_iterator("get_hash_keys_iterator", InteropMethodNames.T_GET_HASH_KEYS_ITERATOR),
    get_hash_size("get_hash_size", InteropMethodNames.T_GET_HASH_SIZE),
    get_hash_values_iterator("get_hash_values_iterator", InteropMethodNames.T_GET_HASH_VALUES_ITERATOR),
    is_hash_entry_readable("is_hash_entry_readable", InteropMethodNames.T_IS_HASH_ENTRY_READABLE, 1),
    is_hash_entry_modifiable("is_hash_entry_modifiable", InteropMethodNames.T_IS_HASH_ENTRY_MODIFIABLE, 1),
    is_hash_entry_insertable("is_hash_entry_insertable", InteropMethodNames.T_IS_HASH_ENTRY_INSERTABLE, 1),
    is_hash_entry_removable("is_hash_entry_removable", InteropMethodNames.T_IS_HASH_ENTRY_REMOVABLE, 1),
    read_hash_value("get_hash_value", InteropMethodNames.T_READ_HASH_VALUE, 1),
    write_hash_entry("write_hash_entry", InteropMethodNames.T_WRITE_HASH_ENTRY, 2),
    remove_hash_entry("remove_hash_entry", InteropMethodNames.T_REMOVE_HASH_ENTRY, 1);

    public static final InteropBehaviorMethod[] VALUES;
    public final String name;
    public final TruffleString tsName;
    public final int extraArguments;
    public final boolean takesVarArgs;

    public static int getLength() {
        return VALUES.length;
    }

    private InteropBehaviorMethod(String name, TruffleString tsName, int extraArguments, boolean takesVarArgs) {
        this.name = name;
        this.tsName = tsName;
        this.extraArguments = extraArguments;
        this.takesVarArgs = takesVarArgs;
    }

    private InteropBehaviorMethod(String name, TruffleString tsName, int extraArguments) {
        this(name, tsName, extraArguments, false);
    }

    private InteropBehaviorMethod(String name, TruffleString tsName) {
        this(name, tsName, 0);
    }

    public boolean checkArity(Object[] extraArguments) {
        return this.takesVarArgs || extraArguments.length == this.extraArguments;
    }

    public int getNumPositionalArguments() {
        return this.extraArguments + 1;
    }

    public String toString() {
        return "InteropBehaviorMethod{name='" + this.name + "', extraArguments=" + this.extraArguments + ", takesVarArgs=" + this.takesVarArgs + "}";
    }

    static {
        VALUES = InteropBehaviorMethod.values();
    }
}

