/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;

public abstract class ArrayBasedSequenceStorage
extends SequenceStorage {
    public abstract Object getInternalArrayObject();

    public abstract Object getCopyOfInternalArrayObject();

    public abstract void setInternalArrayObject(Object var1);

    public abstract ArrayBasedSequenceStorage createEmpty(int var1);

    protected static int capacityFor(int length) throws ArithmeticException {
        return Math.max(16, Math.multiplyExact(length, 2));
    }

    public void minimizeCapacity() {
        this.capacity = this.length;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName()).append('[');
        int len = this.length > 10 ? 10 : this.length;
        for (int i = 0; i < len; ++i) {
            str.append(i == 0 ? "" : ", ");
            str.append(SequenceStorageNodes.GetItemScalarNode.executeUncached(this, i));
        }
        if (this.length > 10) {
            str.append("...").append('(').append(this.length).append(')');
        }
        return str.append(']').toString();
    }
}

