/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.errors.JavaErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaASCII;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaUnicodeProperties;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;

public final class JavaRegexLexer
extends RegexLexer {
    public static final CodePointSet HORIZONTAL_WHITE_SPACE = CodePointSet.createNoDedup(9, 9, 32, 32, 160, 160, 5760, 5760, 6158, 6158, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288);
    public static final CodePointSet NOT_HORIZONTAL_WHITE_SPACE = CodePointSet.createNoDedup(0, 8, 10, 31, 33, 159, 161, 5759, 5761, 6157, 6159, 8191, 8203, 8238, 8240, 8286, 8288, 12287, 12289, 0x10FFFF);
    public static final CodePointSet VERTICAL_WHITE_SPACE = CodePointSet.createNoDedup(10, 13, 133, 133, 8232, 8233);
    public static final CodePointSet NOT_VERTICAL_WHITE_SPACE = CodePointSet.createNoDedup(0, 9, 14, 132, 134, 8231, 8234, 0x10FFFF);
    private static final TBitSet WHITESPACE = TBitSet.valueOf(9, 10, 12, 13, 32);
    private static final TBitSet PREDEFINED_CHAR_CLASSES = TBitSet.valueOf(68, 72, 83, 86, 87, 100, 104, 115, 118, 119);
    private static final TBitSet LATIN1_CHARS_THAT_CASE_FOLD_TO_NON_LATIN1_CHARS = TBitSet.valueOf(73, 75, 83, 105, 107, 115, 181, 197, 229, 255);
    final JavaUnicodeProperties unicode;
    private final Deque<JavaFlags> flagsStack = new ArrayDeque<JavaFlags>();
    private JavaFlags currentFlags;
    private final CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();

    @Override
    protected Token literalChar(int codePoint) {
        if (this.featureEnabledIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.addCodePoint(codePoint);
            this.caseFoldUnfold(this.curCharClass);
            return Token.createCharClass(this.curCharClass.toCodePointSet());
        }
        return Token.createCharClass(CodePointSet.create(codePoint));
    }

    public JavaRegexLexer(RegexSource source, JavaFlags flags, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        if (flags.isCanonEq()) {
            throw new UnsupportedRegexException("Canonical equivalence is not supported");
        }
        if (flags.isLiteral()) {
            throw new UnsupportedRegexException("Literal parsing is not supported");
        }
        this.unicode = JavaUnicodeProperties.create(source.getOptions());
        this.currentFlags = flags;
    }

    @Override
    protected boolean isPredefCharClass(char c) {
        return PREDEFINED_CHAR_CLASSES.get(c);
    }

    JavaFlags getLocalFlags() {
        return this.currentFlags;
    }

    public void pushLocalFlags() {
        this.flagsStack.push(this.currentFlags);
    }

    public void popLocalFlags() {
        this.currentFlags = this.flagsStack.pop();
    }

    public void setCurrentFlags(JavaFlags flags) {
        this.currentFlags = flags;
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.getLocalFlags().isCaseInsensitive();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return true;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return true;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledPossessiveQuantifiers() {
        return true;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected boolean featureEnabledCCRangeWithPredefCharClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return false;
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return false;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return this.getLocalFlags().isComments();
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return this.getLocalFlags().isComments();
    }

    @Override
    protected TBitSet getWhitespace() {
        return WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return true;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return true;
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return true;
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        CaseFoldData.CaseFoldUnfoldAlgorithm caseFolding = this.getLocalFlags().isUnicodeCase() || this.getLocalFlags().isUnicodeCharacterClass() ? CaseFoldData.CaseFoldUnfoldAlgorithm.JavaUnicode : CaseFoldData.CaseFoldUnfoldAlgorithm.Ascii;
        CaseFoldData.applyCaseFoldUnfold(charClass, this.compilationBuffer.getCodePointSetAccumulator1(), caseFolding);
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.getLocalFlags().isDotAll() ? Constants.DOT_ALL : (this.getLocalFlags().isUnixLines() ? JavaUnicodeProperties.DOT_UNIX : JavaUnicodeProperties.DOT);
    }

    @Override
    protected CodePointSet getIdStart() {
        return JavaASCII.ALPHA;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return JavaASCII.ALNUM;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        int n = this.getNumberOfParsedGroups();
        int digits = 1;
        while (n >= 10) {
            n /= 10;
            ++digits;
        }
        return digits;
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        char lowerCaseC = Character.toLowerCase(c);
        if (this.getLocalFlags().isUnicodeCharacterClass() && lowerCaseC != 'v' && lowerCaseC != 'h') {
            switch (c) {
                case 'd': {
                    return this.unicode.digit;
                }
                case 'D': {
                    return this.unicode.nonDigit;
                }
                case 's': {
                    return this.unicode.space;
                }
                case 'S': {
                    return this.unicode.nonSpace;
                }
                case 'w': {
                    return this.unicode.word;
                }
                case 'W': {
                    return this.unicode.nonWord;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        switch (c) {
            case 's': {
                return JavaASCII.SPACE;
            }
            case 'S': {
                return JavaASCII.NON_SPACE;
            }
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 'w': {
                return Constants.WORD_CHARS;
            }
            case 'W': {
                return Constants.NON_WORD_CHARS;
            }
            case 'v': {
                return VERTICAL_WHITE_SPACE;
            }
            case 'V': {
                return NOT_VERTICAL_WHITE_SPACE;
            }
            case 'h': {
                return HORIZONTAL_WHITE_SPACE;
            }
            case 'H': {
                return NOT_HORIZONTAL_WHITE_SPACE;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("Illegal repetition range", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected Token handleBoundedQuantifierEmptyOrMissingMin() {
        throw this.syntaxError("Illegal repetition range", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected Token handleBoundedQuantifierInvalidCharacter() {
        throw this.syntaxError("Unclosed counted closure", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        throw this.syntaxError("Illegal repetition range", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        throw this.syntaxError("Illegal repetition range", RegexSyntaxException.ErrorCode.InvalidQuantifier);
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
        throw this.syntaxError(JavaErrorMessages.groupRedefinition(name), RegexSyntaxException.ErrorCode.InvalidNamedGroup);
    }

    @Override
    protected void handleIncompleteEscapeX() {
        throw this.syntaxError("Illegal hexadecimal escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
    }

    @Override
    protected Token handleInvalidBackReference(int reference) {
        int clamped = reference;
        while (clamped >= 10 && clamped >= this.getNumberOfParsedGroups()) {
            clamped /= 10;
            --this.position;
        }
        if (clamped >= this.getNumberOfParsedGroups()) {
            return Token.createCharClass(CodePointSet.getEmpty());
        }
        return Token.createBackReference(clamped, false);
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        return this.syntaxError("Unknown inline modifier", RegexSyntaxException.ErrorCode.InvalidGroup);
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleOctalOutOfRange() {
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("Unescaped trailing backslash", RegexSyntaxException.ErrorCode.InvalidEscape);
    }

    @Override
    protected void handleUnfinishedGroupComment() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxError("Unknown inline modifier", RegexSyntaxException.ErrorCode.InvalidGroup);
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnmatchedRightBrace() {
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("Unclosed character class", RegexSyntaxException.ErrorCode.UnmatchedBracket);
    }

    @Override
    protected void handleUnmatchedRightBracket() {
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    @Override
    protected ClassSetContents parseClassSetExpression() throws RegexSyntaxException {
        return ClassSetContents.createCharacterClass(this.parseCharClassInternal(true));
    }

    @Override
    protected ClassSetContents parseUnicodeCharacterProperty(boolean invert) throws RegexSyntaxException {
        String name;
        if (this.atEnd()) {
            name = String.valueOf('\u0000');
        } else if (!this.consumingLookahead("{")) {
            name = String.valueOf(this.consumeChar());
        } else {
            int namePos = this.position;
            while (!this.atEnd() && this.curChar() != '}') {
                this.advance();
            }
            if (!this.consumingLookahead("}")) {
                throw this.syntaxError("Unclosed character family", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
            name = this.pattern.substring(namePos, this.position - 1);
            if (name.isEmpty()) {
                throw this.syntaxError("Empty character family", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
        }
        CodePointSet p = null;
        int i = name.indexOf(61);
        if (i != -1) {
            String value = name.substring(i + 1);
            switch (name = name.substring(0, i).toLowerCase(Locale.ENGLISH)) {
                case "sc": 
                case "script": {
                    p = this.unicode.getScript(value);
                    break;
                }
                case "blk": 
                case "block": {
                    p = this.unicode.getBlock(value);
                    break;
                }
                case "gc": 
                case "general_category": {
                    p = this.unicode.getProperty(value, this.getLocalFlags().isCaseInsensitive());
                    break;
                }
            }
            if (p == null) {
                throw this.syntaxError(JavaErrorMessages.unknownUnicodeProperty(name, value), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
        } else {
            if (name.startsWith("In")) {
                p = this.unicode.getBlock(name.substring(2));
            } else if (name.startsWith("Is")) {
                String shortName = name.substring(2);
                p = this.unicode.forUnicodeProperty(shortName, this.getLocalFlags().isCaseInsensitive());
                if (p == null) {
                    p = this.unicode.getProperty(shortName, this.getLocalFlags().isCaseInsensitive());
                }
                if (p == null) {
                    p = this.unicode.getScript(shortName);
                }
            } else {
                if (this.getLocalFlags().isUnicodeCharacterClass()) {
                    p = this.unicode.forPOSIXName(name, this.getLocalFlags().isCaseInsensitive());
                }
                if (p == null) {
                    p = this.unicode.getProperty(name, this.getLocalFlags().isCaseInsensitive());
                }
            }
            if (p == null) {
                throw this.syntaxError(JavaErrorMessages.unknownUnicodeCharacterProperty(name), RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
        }
        if (invert) {
            p = p.createInverse(Encodings.UTF_16);
        }
        return ClassSetContents.createCharacterClass(p);
    }

    private CodePointSet parseCharClassInternal(boolean consume) throws RegexSyntaxException {
        boolean invert = false;
        if (this.curChar() == '^' && this.pattern.charAt(this.position - 1) == '[') {
            this.advance();
            invert = true;
        }
        CodePointSet curr = null;
        CodePointSet prev = null;
        CodePointSet bits = CodePointSet.getEmpty();
        boolean hasBits = false;
        while (!this.atEnd()) {
            int c;
            CodePointSet range;
            if (this.consumingLookahead('[')) {
                curr = this.parseCharClassInternal(true);
                if (prev == null) {
                    prev = curr;
                    continue;
                }
                prev = prev.union(curr);
                continue;
            }
            if (this.consumingLookahead('&')) {
                if (this.consumingLookahead('&')) {
                    CodePointSet right = null;
                    if (this.atEnd()) continue;
                    while (this.curChar() != ']' && this.curChar() != '&') {
                        if (this.consumingLookahead('[')) {
                            if (right == null) {
                                right = this.parseCharClassInternal(true);
                                continue;
                            }
                            right = right.union(this.parseCharClassInternal(true));
                            continue;
                        }
                        if (right == null) {
                            right = this.parseCharClassInternal(false);
                            continue;
                        }
                        right = right.union(this.parseCharClassInternal(false));
                    }
                    if (hasBits) {
                        prev = prev == null ? (curr = bits) : prev.union(bits);
                        hasBits = false;
                    }
                    if (right != null) {
                        curr = right;
                    }
                    if (prev == null) {
                        if (right == null) {
                            throw this.syntaxError("Bad class syntax", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
                        }
                        prev = right;
                        continue;
                    }
                    if (curr == null) {
                        throw this.syntaxError("Bad intersection syntax", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
                    }
                    prev = prev.createIntersection(curr, this.compilationBuffer);
                    continue;
                }
                this.retreat();
            } else if (this.curChar() == ']' && (prev != null || hasBits)) {
                if (consume) {
                    this.advance();
                }
                if (prev == null) {
                    prev = bits;
                } else if (hasBits) {
                    prev = prev.union(bits);
                }
                this.curCharClass.clear();
                this.curCharClass.addSet(prev);
                if (this.featureEnabledIgnoreCase()) {
                    this.caseFoldUnfold(this.curCharClass);
                }
                prev = this.curCharClass.toCodePointSet();
                if (invert) {
                    return prev.createInverse(Encodings.UTF_16);
                }
                return prev;
            }
            char ch = this.consumeChar();
            ClassSetContents predef = this.parseCharClassAtomPredefCharClass(ch);
            if (predef != null) {
                curr = predef.getCodePointSet();
                if (prev == null) {
                    prev = curr;
                    continue;
                }
                prev = prev.union(curr);
                continue;
            }
            curr = range = this.parseRange(ch);
            if (!(range.size() != 1 || range.getRanges()[0] != range.getRanges()[1] || (c = range.getRanges()[0]) >= 256 || this.getLocalFlags().isCaseInsensitive() && this.getLocalFlags().isUnicodeCase() && LATIN1_CHARS_THAT_CASE_FOLD_TO_NON_LATIN1_CHARS.get(c))) {
                hasBits = true;
                curr = null;
                bits = bits.union(range);
            }
            if (curr == null) continue;
            if (prev == null) {
                prev = curr;
                continue;
            }
            prev = prev.union(curr);
        }
        throw this.syntaxError("Unclosed character class", RegexSyntaxException.ErrorCode.UnmatchedBracket);
    }

    private CodePointSet parseRange(char c) {
        int ch = this.parseCharClassAtomCodePoint(c);
        if (this.consumingLookahead('-')) {
            if (this.atEnd()) {
                throw this.syntaxError("Illegal character range", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
            if (this.curChar() == ']' || this.curChar() == '[') {
                this.retreat();
                return CodePointSet.create(ch);
            }
            int upper = this.parseCharClassAtomCodePoint(this.consumeChar());
            if (upper < ch) {
                throw this.syntaxError("Illegal character range", RegexSyntaxException.ErrorCode.InvalidCharacterClass);
            }
            return CodePointSet.create(ch, upper);
        }
        return CodePointSet.create(ch);
    }

    @Override
    protected Token parseCustomEscape(char c) {
        switch (c) {
            case 'b': {
                if (this.consumingLookahead("{g}")) {
                    throw new UnsupportedRegexException("Extended grapheme cluster boundaries are not supported");
                }
                return Token.createWordBoundary();
            }
            case 'B': {
                return Token.createNonWordBoundary();
            }
            case 'k': {
                if (this.atEnd()) {
                    this.handleUnfinishedEscape();
                }
                if (this.consumeChar() != '<') {
                    throw this.syntaxError("\\k is not followed by '<' for named capturing group", RegexSyntaxException.ErrorCode.InvalidBackReference);
                }
                String groupName = this.javaParseGroupName();
                if (this.namedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(this.getSingleNamedGroupNumber(groupName), false);
                }
                throw this.syntaxError(JavaErrorMessages.unknownGroupReference(groupName), RegexSyntaxException.ErrorCode.InvalidBackReference);
            }
            case 'R': {
                return Token.createLineBreak();
            }
            case 'X': {
                throw new UnsupportedRegexException("Grapheme clusters are not supported");
            }
            case 'G': {
                throw new UnsupportedRegexException("End of previous match boundary matcher is not supported");
            }
            case 'Q': {
                int start = this.position;
                int end = this.pattern.indexOf("\\E", start);
                this.position = end < 0 ? (end = this.pattern.length()) : end + 2;
                return Token.createLiteralString(start, end);
            }
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 'b': {
                throw this.syntaxError("Illegal/unsupported escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
            case '0': {
                if (this.lookahead(RegexLexer::isOctalDigit, 1)) {
                    return this.parseOctal(0, 3);
                }
                throw this.syntaxError("Illegal octal escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
            case 'u': {
                int n = this.parseUnicodeHexEscape();
                if (Character.isHighSurrogate((char)n)) {
                    int n2;
                    int cur = this.position;
                    if (this.consumingLookahead("\\u") && Character.isLowSurrogate((char)(n2 = this.parseUnicodeHexEscape()))) {
                        return Character.toCodePoint((char)n, (char)n2);
                    }
                    this.position = cur;
                }
                return n;
            }
            case 'x': {
                if (this.consumingLookahead('{')) {
                    int hex = this.parseHex(1, 8, 0x10FFFF, () -> {
                        throw this.syntaxError("Illegal hexadecimal escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
                    }, () -> {
                        throw this.syntaxError("Hexadecimal codepoint is too big", RegexSyntaxException.ErrorCode.InvalidEscape);
                    });
                    if (!this.consumingLookahead('}')) {
                        throw this.syntaxError("Unclosed hexadecimal escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
                    }
                    return hex;
                }
                return -1;
            }
            case 'c': {
                if (this.atEnd()) {
                    throw this.syntaxError("Illegal control escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
                }
                return this.consumeChar() ^ 0x40;
            }
            case 'N': {
                if (this.consumingLookahead('{')) {
                    int i = this.position;
                    if (!this.findChars('}')) {
                        throw this.syntaxError("Unclosed character name escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
                    }
                    this.advance();
                    String name = this.pattern.substring(i, this.position - 1);
                    try {
                        return Character.codePointOf(name);
                    }
                    catch (IllegalArgumentException x) {
                        throw this.syntaxError(JavaErrorMessages.unknownCharacterName(name), RegexSyntaxException.ErrorCode.InvalidEscape);
                    }
                }
                throw this.syntaxError("Illegal character name escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
            }
            case 'a': {
                return 7;
            }
            case 'e': {
                return 27;
            }
            case 'Q': {
                throw new UnsupportedRegexException("Literal escape not supported in this context");
            }
        }
        return -1;
    }

    private int parseUnicodeHexEscape() {
        if (this.consumingLookahead(RegexLexer::isHexDigit, 4)) {
            return Integer.parseInt(this.pattern, this.position - 4, this.position, 16);
        }
        throw this.syntaxError("Illegal Unicode escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
            throw this.syntaxError("Illegal/unsupported escape sequence", RegexSyntaxException.ErrorCode.InvalidEscape);
        }
        return c;
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        char c = charAfterQuestionMark;
        if (c == '>') {
            throw new UnsupportedRegexException("Independent non-capturing groups are not supported");
        }
        int firstCharPos = this.position;
        JavaFlags newFlags = this.getLocalFlags();
        while (JavaFlags.isValidFlagChar(c)) {
            newFlags = newFlags.addFlag(c);
            if (this.atEnd()) {
                throw this.handleUnfinishedGroupQ();
            }
            c = this.consumeChar();
        }
        if (c == '-') {
            if (this.atEnd()) {
                throw this.handleUnfinishedGroupQ();
            }
            c = this.consumeChar();
            while (JavaFlags.isValidFlagChar(c)) {
                newFlags = newFlags.delFlag(c);
                if (this.atEnd()) {
                    throw this.handleUnfinishedGroupQ();
                }
                c = this.consumeChar();
            }
        }
        if (c == ':') {
            if (firstCharPos == this.position) {
                return null;
            }
            return Token.createInlineFlags(newFlags, false);
        }
        if (c == ')') {
            return Token.createInlineFlags(newFlags, true);
        }
        return null;
    }

    @Override
    protected Token parseGroupLt() {
        this.registerNamedCaptureGroup(this.javaParseGroupName());
        return Token.createCaptureGroupBegin();
    }

    private String javaParseGroupName() {
        RegexLexer.ParseGroupNameResult result = this.parseGroupName('>');
        switch (result.state) {
            case empty: 
            case invalidStart: {
                throw this.syntaxError("capturing group name does not start with a Latin letter", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case unterminated: 
            case invalidRest: {
                throw this.syntaxError("named capturing group is missing trailing '>'", RegexSyntaxException.ErrorCode.InvalidNamedGroup);
            }
            case valid: {
                return result.groupName;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }
}

