/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.BytecodeOSRValidation;
import com.oracle.truffle.api.nodes.NodeAccessor;
import com.oracle.truffle.api.nodes.NodeInterface;

public interface BytecodeOSRNode
extends NodeInterface {
    default public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterState) {
        throw new AbstractMethodError();
    }

    default public Object executeOSR(VirtualFrame osrFrame, long target, Object interpreterState) {
        int intTarget = (int)target;
        if ((long)intTarget != target) {
            throw CompilerDirectives.shouldNotReachHere("long target used without implementing long overload of executeOSR");
        }
        return this.executeOSR(osrFrame, intTarget, interpreterState);
    }

    public Object getOSRMetadata();

    public void setOSRMetadata(Object var1);

    @Deprecated(since="22.2")
    default public void copyIntoOSRFrame(VirtualFrame osrFrame, VirtualFrame parentFrame, int target) {
        NodeAccessor.RUNTIME.transferOSRFrame(this, parentFrame, osrFrame, target);
    }

    default public void copyIntoOSRFrame(VirtualFrame osrFrame, VirtualFrame parentFrame, int target, Object targetMetadata) {
        NodeAccessor.RUNTIME.transferOSRFrame(this, parentFrame, osrFrame, target, targetMetadata);
    }

    default public void copyIntoOSRFrame(VirtualFrame osrFrame, VirtualFrame parentFrame, long target, Object targetMetadata) {
        int intTarget = (int)target;
        if ((long)intTarget != target) {
            throw CompilerDirectives.shouldNotReachHere("long target used without implementing long overload of copyIntoOSRFrame");
        }
        this.copyIntoOSRFrame(osrFrame, parentFrame, intTarget, targetMetadata);
    }

    default public void transferOSRFrame(VirtualFrame osrFrame, VirtualFrame parentFrame, long target, Object targetMetadata) {
        NodeAccessor.RUNTIME.transferOSRFrame(this, parentFrame, osrFrame, target, targetMetadata);
    }

    default public void restoreParentFrame(VirtualFrame osrFrame, VirtualFrame parentFrame) {
        NodeAccessor.RUNTIME.restoreOSRFrame(this, osrFrame, parentFrame);
    }

    default public void prepareOSR(int target) {
    }

    default public void prepareOSR(long target) {
        int intTarget = (int)target;
        if ((long)intTarget != target) {
            throw CompilerDirectives.shouldNotReachHere("long target used without implementing long overload of prepareOSR");
        }
        this.prepareOSR(intTarget);
    }

    public static boolean pollOSRBackEdge(BytecodeOSRNode osrNode) {
        if (!CompilerDirectives.inInterpreter()) {
            return false;
        }
        if (!1.$assertionsDisabled && !BytecodeOSRValidation.validateNode(osrNode)) {
            throw new AssertionError();
        }
        return NodeAccessor.RUNTIME.pollBytecodeOSRBackEdge(osrNode);
    }

    public static Object tryOSR(BytecodeOSRNode osrNode, int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        return NodeAccessor.RUNTIME.tryBytecodeOSR(osrNode, target, interpreterState, beforeTransfer, parentFrame);
    }

    public static Object tryOSR(BytecodeOSRNode osrNode, long target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        return NodeAccessor.RUNTIME.tryBytecodeOSR(osrNode, target, interpreterState, beforeTransfer, parentFrame);
    }

    default public Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        return new Object[]{parentFrame};
    }

    default public Frame restoreParentFrameFromArguments(Object[] arguments) {
        return (Frame)arguments[0];
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

