/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.List;
import org.infinispan.ppg.generator.Action;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.Resolvable;
import org.infinispan.ppg.generator.RuleDefinition;

public class Intrinsic
implements Resolvable {
    private final String qualifiedName;
    private final String varName;
    private final String callCode;
    private final String type;
    final String file;
    final int line;

    Intrinsic(String qualifiedName, String callCode, String type, String file, int line) {
        this.qualifiedName = qualifiedName;
        this.varName = qualifiedName.replaceAll("\\.", "_");
        this.callCode = callCode;
        this.type = type;
        this.file = file;
        this.line = line;
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String sourceName() {
        return this.varName;
    }

    @Override
    public Machine.State addStates(Machine.State prev, Machine.State target, Machine machine, Grammar grammar, List<RuleDefinition> ruleStack, Reference reference) {
        StringBuilder code = new StringBuilder();
        code.append(this.varName).append(" = ").append(this.callCode).append("(buf");
        if (reference.params != null) {
            for (Action action : reference.params) {
                code.append(", ").append(action.code(grammar));
            }
        }
        code.append(')');
        return prev.requireCall(code.toString(), target, ruleStack);
    }

    @Override
    public String analyzeType(Grammar grammar) {
        return this.type;
    }
}

