/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.parser;

public class AliasTypeSpec
extends TypeSpec {
    public TypeSpec originalType;
    private boolean written;
    private boolean originalTypeWasScopedName = false;

    public AliasTypeSpec(TypeSpec ts) {
        super(IdlSymbol.new_num());
        this.originalType = ts;
    }

    @Override
    public Object clone() {
        AliasTypeSpec alias = new AliasTypeSpec((TypeSpec)this.type_spec.clone());
        alias.name = this.name;
        alias.pack_name = this.pack_name;
        return alias;
    }

    @Override
    public String full_name() {
        if (this.pack_name.length() > 0) {
            String fullName = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            return this.getFullName(fullName);
        }
        return ScopedName.unPseudoName(this.name);
    }

    @Override
    public String typeName() {
        return this.originalType.typeName();
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    public TypeSpec originalType() {
        if (this.originalType instanceof AliasTypeSpec) {
            return ((AliasTypeSpec)this.originalType).originalType();
        }
        return this.originalType;
    }

    @Override
    public void setPackage(String s) {
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.pack_name = parser.pack_replace(this.pack_name);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public boolean basic() {
        return false;
    }

    @Override
    public void parse() {
        if (this.originalType instanceof TemplateTypeSpec) {
            ((TemplateTypeSpec)this.originalType).markTypeDefd();
        }
        if (this.originalType instanceof ConstrTypeSpec || this.originalType instanceof FixedPointType || this.originalType instanceof SequenceType || this.originalType instanceof ArrayTypeSpec) {
            this.originalType.parse();
            if (this.originalType.typeName().indexOf(46) < 0) {
                String tName = null;
                tName = this.originalType instanceof VectorType ? this.originalType.typeName().substring(0, this.originalType.typeName().indexOf(91)) : this.originalType.typeName();
                this.addImportedName(tName);
            }
        }
        if (this.originalType instanceof ScopedName) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" Alias " + this.name + " has scoped name orig Type : " + ((ScopedName)this.originalType).toString());
            }
            this.originalType = ((ScopedName)this.originalType).resolvedTypeSpec();
            this.originalTypeWasScopedName = true;
            if (this.originalType instanceof AliasTypeSpec) {
                this.addImportedAlias(this.originalType.full_name());
            } else {
                this.addImportedName(this.originalType.typeName());
            }
        }
    }

    @Override
    public String toString() {
        return this.originalType.toString();
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        return "org.omg.CORBA.ORB.init().create_alias_tc(" + this.full_name() + "Helper.id(), \"" + this.name + "\"," + this.originalType.typeSpec().getTypeCodeExpression(knownTypes) + ")";
    }

    public String className() {
        String cName;
        String fullName = this.full_name();
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            cName = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    @Override
    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            this.written = true;
            try {
                File f;
                if (!(this.originalType instanceof FixedPointType || this.originalType.typeSpec() instanceof ArrayTypeSpec || this.originalType.typeSpec() instanceof StringType || this.originalType.typeSpec() instanceof SequenceType || this.originalTypeWasScopedName || this.originalType instanceof ConstrTypeSpec && ((ConstrTypeSpec)this.originalType).declaration() instanceof Interface)) {
                    this.originalType.print(ps);
                }
                if (this.originalType.typeSpec() instanceof ArrayTypeSpec) {
                    this.originalType.type_spec.print(ps);
                }
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                String fname = null;
                PrintWriter decl_ps = null;
                if (this.originalType instanceof TemplateTypeSpec && !(this.originalType instanceof StringType) && GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, decl_ps);
                    decl_ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, decl_ps);
                    decl_ps.close();
                }
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public String printReadStatement(String varname, String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printReadStatement(varname, streamname);
        }
        return varname + " = " + this.full_name() + "Helper.read(" + streamname + ");";
    }

    @Override
    public String printReadExpression(String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printReadExpression(streamname);
        }
        return this.full_name() + "Helper.read(" + streamname + ")";
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printWriteStatement(var_name, streamname);
        }
        return this.full_name() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    private boolean doUnwind() {
        return this.originalType.basic() && (!(this.originalType instanceof TemplateTypeSpec) || this.originalType instanceof StringType) || this.originalType instanceof AliasTypeSpec || this.originalType instanceof ConstrTypeSpec || this.originalType instanceof AnyType;
    }

    @Override
    public String holderName() {
        if (this.doUnwind()) {
            return this.originalType.holderName();
        }
        return this.full_name() + "Holder";
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment("alias", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.originalType.typeName() + " value;" + Environment.NL);
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + this.originalType.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        boolean useAnySpeedAccessor;
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment("alias", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate volatile static org.omg.CORBA.TypeCode _type;" + Environment.NL);
        String type = this.originalType.typeName();
        ps.println("\tpublic static void insert (org.omg.CORBA.Any any, " + type + " s)");
        ps.println("\t{");
        TypeSpec origType = this.originalType();
        boolean bl = useAnySpeedAccessor = !(origType instanceof TemplateTypeSpec) && !(origType instanceof ConstrTypeSpec) && BaseType.isBasicName(origType.typeName());
        if (useAnySpeedAccessor) {
            ps.print("\t\tany.");
            ps.print(this.originalType().printInsertExpression());
            ps.println("(s);");
        } else {
            ps.println("\t\tany.type (type ());");
            ps.println("\t\twrite (any.create_output_stream (), s);");
        }
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static " + type + " extract (final org.omg.CORBA.Any any)");
        ps.println("\t{");
        if (useAnySpeedAccessor) {
            ps.print("\t\treturn any.");
            ps.print(this.originalType().printExtractExpression());
            ps.println("();");
        } else {
            ps.println("\t\tif ( any.type().kind() == org.omg.CORBA.TCKind.tk_null)");
            ps.println("\t\t{");
            ps.println("\t\t\tthrow new org.omg.CORBA.BAD_OPERATION (\"Can't extract from Any with null type.\");");
            ps.println("\t\t}");
            ps.println("\t\treturn read (any.create_input_stream ());");
        }
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        ps.println("\t\t\tsynchronized(" + className + "Helper.class)");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif (_type == null)");
        ps.println("\t\t\t\t{");
        ps.println("\t\t\t\t\t_type = " + this.getTypeCodeExpression() + ";");
        ps.println("\t\t\t\t}");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}" + Environment.NL);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\t" + type + " _result;");
        ps.println("\t\t" + this.originalType.printReadStatement("_result", "_in"));
        ps.println("\t\treturn _result;");
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream _out, " + type + " _s)");
        ps.println("\t{");
        ps.println("\t\t" + this.originalType.printWriteStatement("_s", "_out"));
        ps.println("\t}");
        ps.println("}");
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        String helpername = this.className() + "Helper";
        ps.println("\t\t" + this.pack_name + "." + helpername + ".insert(" + anyname + ", " + varname + " );");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        String helpername = this.className() + "Helper";
        ps.println("\t\t" + resultname + " = " + this.pack_name + "." + helpername + ".extract(" + anyname + ");");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitAlias(this);
    }
}

