/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;
import org.jacorb.idl.util.IDLLogger;

public class NameTable {
    private static final Hashtable names = new Hashtable(10000);
    private static final Map shadows = new Hashtable();
    private static final Map ancestors = new Hashtable();
    private static final Map operationSources = new Hashtable();
    public static final Map parsed_interfaces = new Hashtable();
    static IDLLogger logger;

    public static void init() {
        names.clear();
        operationSources.clear();
        shadows.clear();
        ancestors.clear();
        operationSources.clear();
        parsed_interfaces.clear();
        names.put("char", IDLTypes.TYPE);
        names.put("boolean", IDLTypes.TYPE);
        names.put("long", IDLTypes.TYPE);
        names.put("long", IDLTypes.TYPE);
        names.put("short", IDLTypes.TYPE);
        names.put("int", IDLTypes.TYPE);
        names.put("float", IDLTypes.TYPE);
        names.put("double", IDLTypes.TYPE);
        names.put("byte", IDLTypes.TYPE);
        names.put("void", IDLTypes.TYPE);
        names.put("org.omg.CORBA.Any", IDLTypes.TYPE);
        names.put("org.omg.CORBA.Object", IDLTypes.INTERFACE);
        logger = parser.getLogger();
    }

    private static void checkScopingRules(String name, IDLTypes kind) throws NameAlreadyDefined {
        if (logger.isDebugEnabled()) {
            logger.debug("NameTable.checkScopingRules:  " + name + " kind: " + kind.name());
        }
        if (kind == IDLTypes.ARGUMENT) {
            return;
        }
        StringTokenizer strtok = new StringTokenizer(name.toUpperCase(), ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scopes[i] = strtok.nextToken();
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NameTable.checkScopingRules2:  " + name + " kind: " + kind.name());
        }
        if (scopes.length > 1 && scopes[scopes.length - 2].equals(scopes[scopes.length - 1])) {
            throw new IllegalRedefinition(name);
        }
    }

    public static void define(String name, IDLTypes kind) throws NameAlreadyDefined {
        if (logger.isInfoEnabled()) {
            logger.info("NameTable.define2: putting " + name + " kind " + kind.name() + " hash: " + name.hashCode());
        }
        if (names.containsKey(name) || names.containsKey(name.toUpperCase())) {
            if (kind == IDLTypes.MODULE) {
                return;
            }
            if (parser.strict_identifiers && parser.strict_names && names.containsKey(name) && !names.get(name).equals((Object)kind) && parser.get_pending(name) == null) {
                throw new IllegalRedefinition(name);
            }
            if (!shadows.containsKey(name) || kind == IDLTypes.OPERATION || kind == IDLTypes.INTERFACE) {
                throw new NameAlreadyDefined(name);
            }
            if (logger.isInfoEnabled()) {
                logger.info("NameTable.define2: redefining  " + name);
            }
            shadows.remove(name);
            names.remove(name);
            if (IDLTypes.isTypeKind(kind)) {
                TypeMap.removeDefinition(name);
            }
        }
        if (parser.strict_names) {
            NameTable.checkScopingRules(name, kind);
        }
        if (parser.strict_names) {
            names.put(name.toUpperCase(), IDLTypes.DUMMY);
        }
        names.put(name, kind);
        if (kind == IDLTypes.OPERATION) {
            operationSources.put(name, name.substring(0, name.lastIndexOf(".")));
        }
    }

    private static void defineInheritedOperation(String name, String inheritedFrom) throws NameAlreadyDefined {
        if (names.containsKey(name)) {
            String source = null;
            String opName = name.indexOf(".") < 0 ? name : name.substring(name.lastIndexOf(".") + 1);
            String presentOpName = name;
            while ((source = (String)operationSources.get(presentOpName)) != null && !presentOpName.equals(source + "." + opName)) {
                presentOpName = source + "." + opName;
            }
            if (logger.isInfoEnabled()) {
                logger.info("NameTable source of " + name + " is " + presentOpName);
            }
            String otherOpName = inheritedFrom + "." + opName;
            while ((source = (String)operationSources.get(otherOpName)) != null && !otherOpName.equals(source + "." + opName)) {
                otherOpName = source + "." + opName;
            }
            if (logger.isInfoEnabled()) {
                logger.info("NameTable other source of " + name + " is " + otherOpName);
            }
            if (otherOpName.equals(presentOpName)) {
                return;
            }
            throw new NameAlreadyDefined(name);
        }
        names.put(name, IDLTypes.OPERATION);
        operationSources.put(name, inheritedFrom);
    }

    private static void defineShadows(Hashtable shadowEntries) throws NameAlreadyDefined {
        String firstViolation = null;
        Enumeration e = shadowEntries.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            IDLTypes kind = (IDLTypes)((Object)shadowEntries.get(name));
            if (names.containsKey(name)) {
                firstViolation = name;
                continue;
            }
            names.put(name, kind);
            if (logger.isDebugEnabled()) {
                logger.debug("Put shadow " + name);
            }
            shadows.put(name, "");
            if (kind != IDLTypes.OPERATION) continue;
            operationSources.put(name, name.substring(0, name.lastIndexOf(".")));
        }
        if (firstViolation != null) {
            throw new NameAlreadyDefined(firstViolation);
        }
    }

    public static synchronized void inheritFrom(String name, SymbolList ancestors) throws NameAlreadyDefined {
        block13: {
            Hashtable<String, IDLTypes> shadowNames = new Hashtable<String, IDLTypes>();
            Enumeration e = names.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String s = null;
                if (key.indexOf(46) <= 0) continue;
                s = key.substring(0, key.lastIndexOf(46));
                Enumeration i = ancestors.v.elements();
                while (i.hasMoreElements()) {
                    String anc = ((ScopedName)i.nextElement()).resolvedName();
                    if (!s.equals(anc)) continue;
                    IDLTypes kind = (IDLTypes)((Object)names.get(key));
                    if (logger.isDebugEnabled()) {
                        logger.debug("NameTable.inheritFrom ancestor " + anc + " : key " + key + " kind " + (Object)((Object)kind));
                    }
                    String shadowKey = name + key.substring(key.lastIndexOf(46));
                    shadowNames.put(shadowKey, kind);
                    if (IDLTypes.isTypeKind(kind)) {
                        TypeSpec t;
                        if (logger.isDebugEnabled()) {
                            logger.debug("- NameTable.inherit type from:  " + key);
                        }
                        if ((t = TypeMap.map(anc + key.substring(key.lastIndexOf(46)))) != null) {
                            TypeMap.typedef(name + key.substring(key.lastIndexOf(46)), t);
                        }
                        shadowNames.put(name + key.substring(key.lastIndexOf(46)), kind);
                    } else if (kind == IDLTypes.OPERATION) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("- NameTable.inherit operation from:  " + key);
                        }
                        NameTable.defineInheritedOperation(name + key.substring(key.lastIndexOf(46)), anc);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("- NameTable.inherit " + kind.name() + " from:  " + key);
                    }
                    if (NameTable.isDefined(key)) continue;
                    throw new RuntimeException("CompilerError!");
                }
            }
            try {
                NameTable.defineShadows(shadowNames);
            }
            catch (NameAlreadyDefined nad) {
                if (!logger.isDebugEnabled()) break block13;
                logger.debug("Exception ", nad);
            }
        }
    }

    public static boolean isDefined(String name) {
        return names.containsKey(name);
    }

    public static boolean isDefined(String name, IDLTypes kind) {
        if (!names.containsKey(name)) {
            return false;
        }
        return names.get(name) == kind;
    }

    static boolean baseType(String _s) {
        return _s.equals("int") || _s.equals("short") || _s.equals("long") || _s.equals("float") || _s.equals("boolean") || _s.equals("double") || _s.equals("byte") || _s.equals("char") || _s.equals("void") || _s.equals("org.omg.CORBA.Object") || _s.equals("org.omg.CORBA.Any") || _s.equals("<anon>");
    }
}

