/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.util.Hashtable;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ObjectTypeSpec;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeCodeTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class TypeMap {
    static final Hashtable typemap = new Hashtable(5000);

    public static void init() {
        typemap.clear();
        typemap.put("org.omg.CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("org.omg.CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
    }

    public static TypeSpec map(String name) {
        return (TypeSpec)typemap.get(name);
    }

    public static void typedef(String name, TypeSpec type) {
        if (parser.getLogger().isInfoEnabled()) {
            parser.getLogger().info("Typedef'ing " + name + " , hash: " + type.hashCode());
        }
        if (typemap.containsKey(name)) {
            if (parser.getLogger().isDebugEnabled()) {
                parser.getLogger().info("Typedef'ing " + name + " already in type map!");
            }
        } else if (type.typeSpec() instanceof ScopedName) {
            if (((ScopedName)type.typeSpec()).resolvedTypeSpec() != null) {
                typemap.put(name, ((ScopedName)type.typeSpec()).resolvedTypeSpec());
            } else {
                typemap.put(name, type.typeSpec());
            }
            if (parser.getLogger().isInfoEnabled()) {
                parser.getLogger().info(" resolved " + ((ScopedName)type.typeSpec()).resolvedTypeSpec());
            }
        } else {
            typemap.put(name, type.typeSpec());
            if (parser.getLogger().isInfoEnabled()) {
                parser.getLogger().info(" (not a resolved scoped name) " + type.typeSpec().full_name());
            }
        }
    }

    static void removeDefinition(String name) {
        if (!typemap.containsKey(name)) {
            throw new RuntimeException("Could not find definition of : " + name);
        }
        typemap.remove(name);
    }

    public static void replaceForwardDeclaration(String name, TypeSpec type) {
        if (!typemap.containsKey(name)) {
            throw new RuntimeException("Could not find forward declaration!");
        }
        typemap.remove(name);
        TypeMap.typedef(name, type);
    }
}

