/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.condition.ConditionRunner;
import com.thoughtworks.selenium.condition.JUnitConditionRunner;
import java.util.concurrent.TimeUnit;
import org.jbehave.scenario.annotations.AfterScenario;
import org.jbehave.scenario.annotations.BeforeScenario;
import org.jbehave.scenario.steps.Steps;
import org.jbehave.scenario.steps.StepsConfiguration;
import org.jbehave.web.selenium.SeleniumContext;
import org.jbehave.web.selenium.SeleniumStepsConfiguration;

public class SeleniumSteps
extends Steps {
    protected final Selenium selenium;
    protected final ConditionRunner runner;

    public SeleniumSteps() {
        this(new StepsConfiguration());
    }

    public SeleniumSteps(StepsConfiguration configuration) {
        super(configuration);
        this.selenium = this.createSelenium();
        this.runner = this.createConditionRunner(this.selenium);
    }

    public SeleniumSteps(Selenium selenium) {
        this(new SeleniumStepsConfiguration(selenium, new SeleniumContext()));
    }

    public SeleniumSteps(SeleniumStepsConfiguration configuration) {
        super((StepsConfiguration)configuration);
        this.selenium = configuration.getSelenium();
        this.runner = this.createConditionRunner(this.selenium);
    }

    @BeforeScenario
    public void beforeScenario() throws Exception {
        this.selenium.start();
    }

    @AfterScenario
    public void afterScenario() throws Exception {
        this.selenium.close();
        this.selenium.stop();
    }

    protected Selenium createSelenium() {
        return new DefaultSelenium("localhost", 4444, "*firefox", "http://localhost:8080");
    }

    protected ConditionRunner createConditionRunner(Selenium selenium) {
        return new JUnitConditionRunner(selenium, 10, 100, 1000);
    }

    protected void waitFor(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

