/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.Type;
import org.jbehave.scenario.steps.StepMonitor;
import org.jbehave.web.selenium.SeleniumContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumStepsMonitor
implements StepMonitor {
    private final Selenium selenium;
    private final SeleniumContext seleniumContext;
    private final StepMonitor delegate;

    public SeleniumStepsMonitor(Selenium selenium, SeleniumContext seleniumContext, StepMonitor delegate) {
        this.selenium = selenium;
        this.seleniumContext = seleniumContext;
        this.delegate = delegate;
    }

    public void performing(String step) {
        String context = this.seleniumContext.getCurrentScenario() + "<br>" + step;
        this.selenium.setContext(context);
        this.delegate.performing(step);
    }

    public void convertedValueOfType(String value, Type type, Object converted, Class<?> converterClass) {
        this.delegate.convertedValueOfType(value, type, converted, converterClass);
    }

    public void stepMatchesPattern(String step, boolean matches, String pattern) {
        this.delegate.stepMatchesPattern(step, matches, pattern);
    }

    public void foundArg(String arg, int position) {
        this.delegate.foundArg(arg, position);
    }

    public void usingAnnotatedNameForArg(String name, int position) {
        this.delegate.usingAnnotatedNameForArg(name, position);
    }

    public void usingNaturalOrderForArg(int position) {
        this.delegate.usingNaturalOrderForArg(position);
    }

    public void usingParameterNameForArg(String name, int position) {
        this.delegate.usingParameterNameForArg(name, position);
    }

    public void usingTableAnnotatedNameForArg(String name, int position) {
        this.delegate.usingTableAnnotatedNameForArg(name, position);
    }

    public void usingTableParameterNameForArg(String name, int position) {
        this.delegate.usingTableParameterNameForArg(name, position);
    }
}

