/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.StoryControls;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.RethrowingFailure;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.AbsolutePathCalculator;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.PathCalculator;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.io.UnderscoredCamelCaseResolver;
import org.jbehave.core.parsers.RegexPrefixCapturingPatternParser;
import org.jbehave.core.parsers.RegexStoryParser;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.PrintStreamStepdocReporter;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.MarkUnmatchedStepsAsPending;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;

public abstract class Configuration {
    private StoryControls storyControls = new StoryControls();
    private Keywords keywords = new LocalizedKeywords();
    private StepCollector stepCollector = new MarkUnmatchedStepsAsPending();
    private StoryParser storyParser = new RegexStoryParser(this.keywords);
    private StoryLoader storyLoader = new LoadFromClasspath();
    private StoryPathResolver storyPathResolver = new UnderscoredCamelCaseResolver();
    private FailureStrategy failureStrategy = new RethrowingFailure();
    private PendingStepStrategy pendingStepStrategy = new PassingUponPendingStep();
    private StoryReporter defaultStoryReporter = new ConsoleOutput();
    private StoryReporterBuilder storyReporterBuilder = new StoryReporterBuilder();
    private StepFinder stepFinder = new StepFinder();
    private StepdocReporter stepdocReporter = new PrintStreamStepdocReporter();
    private StepPatternParser stepPatternParser = new RegexPrefixCapturingPatternParser();
    private StepMonitor stepMonitor = new SilentStepMonitor();
    private Paranamer paranamer = new NullParanamer();
    private ParameterConverters parameterConverters = new ParameterConverters();
    private ViewGenerator viewGenerator = new FreemarkerViewGenerator();
    private PathCalculator pathCalculator = new AbsolutePathCalculator();

    public Keywords keywords() {
        return this.keywords;
    }

    public boolean dryRun() {
        return this.storyControls.dryRun();
    }

    public StoryControls storyControls() {
        return this.storyControls;
    }

    public StoryParser storyParser() {
        return this.storyParser;
    }

    public StoryLoader storyLoader() {
        return this.storyLoader;
    }

    public StoryPathResolver storyPathResolver() {
        return this.storyPathResolver;
    }

    public FailureStrategy failureStrategy() {
        return this.failureStrategy;
    }

    public PendingStepStrategy pendingStepStrategy() {
        return this.pendingStepStrategy;
    }

    public StoryReporter defaultStoryReporter() {
        return this.defaultStoryReporter;
    }

    public StoryReporter storyReporter(String storyPath) {
        return this.storyReporterBuilder.build(storyPath);
    }

    public StoryReporterBuilder storyReporterBuilder() {
        return this.storyReporterBuilder;
    }

    public StepCollector stepCollector() {
        return this.stepCollector;
    }

    public StepFinder stepFinder() {
        return this.stepFinder;
    }

    public StepdocReporter stepdocReporter() {
        return this.stepdocReporter;
    }

    public StepPatternParser stepPatternParser() {
        return this.stepPatternParser;
    }

    public StepMonitor stepMonitor() {
        return this.stepMonitor;
    }

    public Paranamer paranamer() {
        return this.paranamer;
    }

    public ParameterConverters parameterConverters() {
        return this.parameterConverters;
    }

    public ViewGenerator viewGenerator() {
        return this.viewGenerator;
    }

    public PathCalculator pathCalculator() {
        return this.pathCalculator;
    }

    public Configuration useKeywords(Keywords keywords) {
        this.keywords = keywords;
        return this;
    }

    public Configuration doDryRun(Boolean dryRun) {
        this.storyControls.doDryRun(dryRun);
        return this;
    }

    public Configuration useStoryControls(StoryControls storyControls) {
        this.storyControls = storyControls;
        return this;
    }

    public Configuration usePendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        this.pendingStepStrategy = pendingStepStrategy;
        return this;
    }

    public Configuration useFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
        return this;
    }

    public Configuration useStoryParser(StoryParser storyParser) {
        this.storyParser = storyParser;
        return this;
    }

    public Configuration useStoryLoader(StoryLoader storyLoader) {
        this.storyLoader = storyLoader;
        return this;
    }

    public Configuration useStoryPathResolver(StoryPathResolver storyPathResolver) {
        this.storyPathResolver = storyPathResolver;
        return this;
    }

    public Configuration useDefaultStoryReporter(StoryReporter storyReporter) {
        this.defaultStoryReporter = storyReporter;
        return this;
    }

    public Configuration useStoryReporterBuilder(StoryReporterBuilder storyReporterBuilder) {
        this.storyReporterBuilder = storyReporterBuilder;
        return this;
    }

    public Configuration useStepCollector(StepCollector stepCollector) {
        this.stepCollector = stepCollector;
        return this;
    }

    public Configuration useStepFinder(StepFinder stepFinder) {
        this.stepFinder = stepFinder;
        return this;
    }

    public Configuration useStepdocReporter(StepdocReporter stepdocReporter) {
        this.stepdocReporter = stepdocReporter;
        return this;
    }

    public Configuration useStepPatternParser(StepPatternParser stepPatternParser) {
        this.stepPatternParser = stepPatternParser;
        return this;
    }

    public Configuration useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        return this;
    }

    public Configuration useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
        return this;
    }

    public Configuration useParameterConverters(ParameterConverters parameterConverters) {
        this.parameterConverters = parameterConverters;
        return this;
    }

    public Configuration useViewGenerator(ViewGenerator viewGenerator) {
        this.viewGenerator = viewGenerator;
        return this;
    }

    public Configuration usePathCalculator(PathCalculator pathCalculator) {
        this.pathCalculator = pathCalculator;
        return this;
    }
}

