/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jbehave.core.configuration.Keywords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedKeywords
extends Keywords {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String DEFAULT_BUNDLE_NAME = "i18n/keywords";
    private static final ClassLoader DEFAULT_CLASS_LOADER = LocalizedKeywords.class.getClassLoader();
    private final Locale locale;

    public LocalizedKeywords() {
        this(DEFAULT_LOCALE);
    }

    public LocalizedKeywords(Locale locale) {
        this(locale, DEFAULT_BUNDLE_NAME, DEFAULT_CLASS_LOADER);
    }

    public LocalizedKeywords(Locale locale, String bundleName, ClassLoader classLoader) {
        super(LocalizedKeywords.keywords(bundleName, locale, classLoader));
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private static Map<String, String> keywords(String bundleName, Locale locale, ClassLoader classLoader) {
        ResourceBundle bundle = LocalizedKeywords.lookupBunde(bundleName.trim(), locale, classLoader);
        HashMap<String, String> keywords = new HashMap<String, String>();
        for (String key : KEYWORDS) {
            keywords.put(key, LocalizedKeywords.keyword(key, bundle));
        }
        return keywords;
    }

    private static String keyword(String name, ResourceBundle bundle) {
        try {
            return bundle.getString(name);
        }
        catch (MissingResourceException e) {
            throw new LocalizedKeywordNotFound(name, bundle);
        }
    }

    private static ResourceBundle lookupBunde(String bundleName, Locale locale, ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return ResourceBundle.getBundle(bundleName, locale, classLoader);
            }
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException e) {
            throw new ResourceBundleNotFound(bundleName, locale, classLoader, e);
        }
    }

    public static class LocalizedKeywordNotFound
    extends RuntimeException {
        public LocalizedKeywordNotFound(String name, ResourceBundle bundle) {
            super("Keyword" + name + " not found in resource bundle " + bundle);
        }
    }

    public static class ResourceBundleNotFound
    extends RuntimeException {
        public ResourceBundleNotFound(String bundleName, Locale locale, ClassLoader classLoader, MissingResourceException cause) {
            super("Resource bundle " + bundleName + " not found for locale " + locale + " in classLoader " + classLoader, cause);
        }
    }
}

