/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryResourceNotFound;

public class LoadFromRelativeFile
implements ResourceLoader,
StoryLoader {
    private final StoryFilePath[] traversals;
    private final URL location;

    public LoadFromRelativeFile(URL location) {
        this(location, LoadFromRelativeFile.mavenModuleStoryFilePath("src/test/java"));
    }

    public LoadFromRelativeFile(URL location, StoryFilePath ... traversals) {
        this.traversals = traversals;
        this.location = location;
    }

    public String loadResourceAsText(String resourcePath) {
        ArrayList<String> traversalPaths = new ArrayList<String>();
        String locationPath = new File(this.location.getFile()).getAbsolutePath();
        for (StoryFilePath traversal : this.traversals) {
            String filePath = locationPath.replace(traversal.toRemove, traversal.relativePath) + "/" + resourcePath;
            File file = new File(filePath);
            if (file.exists()) {
                return this.loadContent(filePath);
            }
            traversalPaths.add(filePath);
        }
        throw new StoryResourceNotFound(resourcePath, traversalPaths);
    }

    public String loadStoryAsText(String storyPath) {
        String locationPath;
        ArrayList<String> traversalPaths = new ArrayList<String>();
        try {
            locationPath = new File(URLDecoder.decode(this.location.getFile(), "UTF-8")).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidStoryResource(storyPath, e);
        }
        for (StoryFilePath traversal : this.traversals) {
            String filePath = locationPath.replace(traversal.toRemove, traversal.relativePath) + "/" + storyPath;
            File file = new File(filePath);
            if (file.exists()) {
                return this.loadContent(filePath);
            }
            traversalPaths.add(filePath);
        }
        throw new StoryResourceNotFound(storyPath, traversalPaths);
    }

    protected String loadContent(String path) {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(new File(path)));
        }
        catch (Exception e) {
            throw new InvalidStoryResource(path, e);
        }
    }

    public static StoryFilePath mavenModuleStoryFilePath(String relativePath) {
        return new StoryFilePath("target/classes", relativePath);
    }

    public static StoryFilePath mavenModuleTestStoryFilePath(String relativePath) {
        return new StoryFilePath("target/test-classes", relativePath);
    }

    public static StoryFilePath intellijProjectStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/production", relativePath);
    }

    public static StoryFilePath intellijProjectTestStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/test", relativePath);
    }

    public static class StoryFilePath {
        private final String toRemove;
        private final String relativePath;

        public StoryFilePath(String toRemove, String relativePath) {
            this.toRemove = toRemove.replace('\\', '/');
            this.relativePath = relativePath.replace('\\', '/');
        }
    }
}

